/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.util.ArrayUtils;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Deprecated(forRemoval=true)
public abstract class AbstractPatternMethodMatcher
implements MethodMatcher {
    protected final Pattern patternWithBySyntax;
    protected final Pattern patternWithoutBySyntax;

    protected AbstractPatternMethodMatcher(boolean supportsProjections, String ... prefixes) {
        if (ArrayUtils.isEmpty((Object[])prefixes)) {
            throw new IllegalArgumentException("At least one prefix required");
        }
        Arrays.sort(prefixes, Comparator.comparingInt(String::length).thenComparing(String::compareTo).reversed());
        this.patternWithBySyntax = AbstractPatternMethodMatcher.compileWithProjectionSyntax(supportsProjections, prefixes);
        this.patternWithoutBySyntax = AbstractPatternMethodMatcher.computeWithoutProjectionSyntax(prefixes);
    }

    @Override
    public final MethodMatcher.MethodMatch match(MethodMatchContext matchContext) {
        String methodName = matchContext.getMethodElement().getName();
        Matcher matcher = this.patternWithBySyntax.matcher(methodName);
        if (matcher.find()) {
            return this.match(matchContext, matcher);
        }
        matcher = this.patternWithoutBySyntax.matcher(methodName);
        if (matcher.find()) {
            return this.match(matchContext, matcher);
        }
        return null;
    }

    protected abstract MethodMatcher.MethodMatch match(MethodMatchContext var1, Matcher var2);

    private static Pattern computeWithoutProjectionSyntax(String[] prefixes) {
        String prefixPattern = String.join((CharSequence)"|", prefixes);
        return Pattern.compile("^((" + prefixPattern + ")(\\S*?))$");
    }

    private static Pattern compileWithProjectionSyntax(boolean supportsProjections, String[] prefixes) {
        String patternStr;
        if (supportsProjections) {
            String prefixPattern = String.join((CharSequence)"|", prefixes);
            patternStr = "((" + prefixPattern + ")([\\w\\d]*?)By)([A-Z]\\w*)";
        } else {
            String prefixPattern = Arrays.stream(prefixes).map(p -> p + "By").collect(Collectors.joining("|"));
            patternStr = "((" + prefixPattern + "))([A-Z]\\w*)";
        }
        return Pattern.compile(patternStr);
    }
}

