/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.criteria;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaUpdate;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaUpdate;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaBuilder;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaUpdate;
import io.micronaut.data.processor.model.criteria.impl.MethodMatchSourcePersistentEntityCriteriaBuilderImpl;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractCriteriaMethodMatch;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodNameParser;
import io.micronaut.data.processor.visitors.finders.QueryMatchId;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.TypedElement;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UpdateCriteriaMethodMatch
extends AbstractCriteriaMethodMatch {
    private final boolean isReturning;

    public UpdateCriteriaMethodMatch(List<MethodNameParser.Match> matches, boolean isReturning) {
        super(matches);
        this.isReturning = isReturning;
    }

    protected <T> void apply(MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
        boolean predicatedApplied = false;
        boolean projectionApplied = false;
        for (MethodNameParser.Match match : this.matches) {
            if (match.id() == QueryMatchId.PREDICATE) {
                this.applyPredicates(match.part(), matchContext.getParameters(), root, query, cb);
                predicatedApplied = true;
            }
            if (match.id() != QueryMatchId.RETURNING) continue;
            this.applyProjections(match.part(), root, query, cb);
            projectionApplied = true;
        }
        if (!predicatedApplied) {
            this.applyPredicates(root, query, cb);
        }
        if (!projectionApplied) {
            this.applyProjections("", root, query, cb);
        }
        SourcePersistentEntity entity = matchContext.getRootEntity();
        this.addPropertiesToUpdate(matchContext, root, query, cb);
        AbstractPersistentEntityCriteriaUpdate criteriaUpdate = (AbstractPersistentEntityCriteriaUpdate)query;
        entity.getPersistentProperties().stream().filter(p -> p != null && p.findAnnotation(AutoPopulated.class).map(ap -> (Boolean)ap.getRequiredValue("updateable", Boolean.class)).orElse(false) != false).forEach(p -> query.set(p.getName(), cb.parameter(null)));
        if (entity.getVersion() != null && criteriaUpdate.hasVersionRestriction()) {
            query.set(entity.getVersion().getName(), cb.parameter(null));
        }
        if (criteriaUpdate.getUpdateValues().isEmpty()) {
            throw new MatchFailedException("At least one parameter required to update");
        }
    }

    protected <T> void applyProjections(String projection, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, PersistentEntityCriteriaBuilder cb) {
        if (!this.isReturning) {
            return;
        }
        List<Selection<?>> selections = this.findSelections(projection, root, cb, null);
        if (selections.isEmpty()) {
            query.returning(root);
        } else if (selections.size() == 1) {
            query.returning(selections.get(0));
        } else {
            throw new MatchFailedException("Multi-selection is not supported");
        }
    }

    protected <T> void addPropertiesToUpdate(MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
    }

    @Override
    protected MethodMatchInfo build(MethodMatchContext matchContext) {
        List<SourcePersistentProperty> dtoProjectionProperties;
        MethodMatchSourcePersistentEntityCriteriaBuilderImpl cb = new MethodMatchSourcePersistentEntityCriteriaBuilderImpl(matchContext);
        PersistentEntityCriteriaUpdate criteriaQuery = cb.createCriteriaUpdate((Class)null);
        PersistentEntityRoot root = criteriaQuery.from((PersistentEntity)matchContext.getRootEntity());
        this.apply(matchContext, root, criteriaQuery, cb);
        FindersUtils.InterceptorMatch interceptorMatch = this.resolveReturnTypeAndInterceptor(matchContext);
        ClassElement resultType = interceptorMatch.returnType();
        ClassElement interceptorType = interceptorMatch.interceptor();
        SourcePersistentEntityCriteriaUpdate criteriaUpdate = (SourcePersistentEntityCriteriaUpdate)criteriaQuery;
        AbstractCriteriaMethodMatch.MethodResult result = this.analyzeMethodResult(matchContext, criteriaUpdate.getQueryResultTypeName(), (ClassElement)matchContext.getVisitorContext().getClassElement(Long.class).orElseThrow(), interceptorMatch, true);
        if (result.isDto() && !result.isRuntimeDtoConversion() && !(dtoProjectionProperties = this.getDtoProjectionProperties(matchContext.getRootEntity(), resultType)).isEmpty()) {
            List selectionList = dtoProjectionProperties.stream().map(p -> {
                if (matchContext.getQueryBuilder().shouldAliasProjections()) {
                    return root.get(p.getName()).alias(p.getName());
                }
                return root.get(p.getName());
            }).collect(Collectors.toList());
            criteriaUpdate.returningMulti(selectionList);
        }
        AbstractPersistentEntityCriteriaUpdate query = (AbstractPersistentEntityCriteriaUpdate)criteriaQuery;
        boolean optimisticLock = query.hasVersionRestriction();
        AnnotationMetadataHierarchy annotationMetadataHierarchy = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{matchContext.getRepositoryClass().getAnnotationMetadata(), matchContext.getAnnotationMetadata()});
        QueryBuilder queryBuilder = matchContext.getQueryBuilder();
        Map propertiesToUpdate = query.getUpdateValues();
        QueryModel queryModel = query.getQueryModel();
        QueryResult queryResult = queryBuilder.buildUpdate((AnnotationMetadata)annotationMetadataHierarchy, queryModel, propertiesToUpdate);
        return new MethodMatchInfo(this.getOperationType(), (TypedElement)result.resultType(), interceptorType).dto(result.isDto()).optimisticLock(optimisticLock).queryResult(queryResult);
    }

    @Override
    protected DataMethod.OperationType getOperationType() {
        if (this.isReturning) {
            return DataMethod.OperationType.UPDATE_RETURNING;
        }
        return DataMethod.OperationType.UPDATE;
    }
}

