/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.jpa.criteria.PersistentAssociationPath;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitor;
import io.micronaut.data.processor.model.SourceAssociation;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.criteria.impl.AbstractSourcePersistentEntityJoinSupport;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentEntityPath;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentPropertyPath;
import jakarta.persistence.criteria.Path;
import java.util.ArrayList;
import java.util.List;

@Internal
final class SourcePersistentAssociationPath<Owner, E>
extends AbstractSourcePersistentEntityJoinSupport<Owner, E>
implements SourcePersistentEntityPath<E>,
SourcePersistentPropertyPath<E>,
PersistentAssociationPath<Owner, E> {
    private final Path<?> parentRoot;
    private final SourceAssociation association;
    private final List<Association> associations;
    private Join.Type associationJoinType;
    @Nullable
    private String alias;

    SourcePersistentAssociationPath(Path<?> parentRoot, SourceAssociation association, List<Association> associations, Join.Type associationJoinType, String alias) {
        this.parentRoot = parentRoot;
        this.association = association;
        this.associations = associations;
        this.associationJoinType = associationJoinType;
        this.alias = alias;
    }

    public Join.Type getAssociationJoinType() {
        return this.associationJoinType;
    }

    public void setAssociationJoinType(@Nullable Join.Type type) {
        this.associationJoinType = type;
    }

    @Nullable
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void accept(SelectionVisitor selectionVisitor) {
        selectionVisitor.visit((PersistentPropertyPath)this);
    }

    public Path<?> getParentPath() {
        return this.parentRoot;
    }

    @Override
    public SourceAssociation getProperty() {
        return this.association;
    }

    @Override
    public List<Association> getAssociations() {
        return this.associations;
    }

    public Association getAssociation() {
        return this.association;
    }

    @Override
    public SourcePersistentEntity getPersistentEntity() {
        return this.association.getAssociatedEntity();
    }

    @Override
    protected List<Association> getCurrentPath() {
        return SourcePersistentAssociationPath.associated(this.getAssociations(), this.association);
    }

    private static List<Association> associated(List<Association> associations, Association association) {
        ArrayList<Association> newAssociations = new ArrayList<Association>(associations.size() + 1);
        newAssociations.addAll(associations);
        newAssociations.add(association);
        return newAssociations;
    }
}

