/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ProviderUtils;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.ClientFilter;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.kubernetes.client.openapi.config.KubeConfig;
import io.micronaut.kubernetes.client.openapi.config.KubeConfigLoader;
import io.micronaut.kubernetes.client.openapi.config.KubernetesClientConfiguration;
import io.micronaut.kubernetes.client.openapi.config.model.AuthInfo;
import io.micronaut.kubernetes.client.openapi.credential.KubernetesTokenLoader;
import io.micronaut.scheduling.annotation.ExecuteOn;
import jakarta.inject.Provider;
import java.util.Collection;
import java.util.Iterator;

@ClientFilter(serviceId={"kubernetes-client"})
@Requires(beans={KubernetesClientConfiguration.class})
@Internal
final class KubernetesHttpClientFilter {
    private final Provider<KubeConfig> kubeConfigProvider = ProviderUtils.memoized(() -> ((KubeConfigLoader)kubeConfigLoader.get()).getKubeConfig());
    private final Provider<Collection<KubernetesTokenLoader>> kubernetesTokenLoaders = ProviderUtils.memoized(() -> applicationContext.getBeansOfType(KubernetesTokenLoader.class));

    KubernetesHttpClientFilter(Provider<KubeConfigLoader> kubeConfigLoader, ApplicationContext applicationContext) {
    }

    @RequestFilter
    @ExecuteOn(value="blocking")
    void doFilter(MutableHttpRequest<?> request) {
        KubernetesTokenLoader kubernetesTokenLoader;
        KubeConfig kubeConfig = (KubeConfig)this.kubeConfigProvider.get();
        if (kubeConfig != null && kubeConfig.getUser() != null) {
            AuthInfo user = kubeConfig.getUser();
            if (user.clientCertificateData() != null && user.clientKeyData() != null) {
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)user.username()) && StringUtils.isNotEmpty((CharSequence)user.password())) {
                request.basicAuth((CharSequence)user.username(), (CharSequence)user.password());
                return;
            }
        }
        String token = null;
        Iterator iterator = ((Collection)this.kubernetesTokenLoaders.get()).iterator();
        while (iterator.hasNext() && !StringUtils.isNotEmpty((CharSequence)(token = (kubernetesTokenLoader = (KubernetesTokenLoader)iterator.next()).getToken()))) {
        }
        if (StringUtils.isNotEmpty(token)) {
            request.bearerAuth(token);
        }
    }
}

