/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.config;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.kubernetes.client.openapi.config.KubeConfig;
import io.micronaut.kubernetes.client.openapi.config.KubeConfigLoader;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public abstract class AbstractKubeConfigLoader
implements KubeConfigLoader {
    private final ResourceResolver resourceResolver;
    private KubeConfig kubeConfig;
    private boolean triedLoading = false;

    protected AbstractKubeConfigLoader(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    @Override
    public KubeConfig getKubeConfig() {
        if (this.kubeConfig == null && !this.triedLoading) {
            this.kubeConfig = this.loadKubeConfig();
            this.triedLoading = true;
        }
        return this.kubeConfig;
    }

    @Nullable
    protected abstract KubeConfig loadKubeConfig();

    protected KubeConfig loadKubeConfigFromFile(String filePath) {
        Optional inputStreamOptional = this.resourceResolver.getResourceAsStream(filePath);
        InputStream inputStream = (InputStream)inputStreamOptional.orElseThrow(() -> new IllegalArgumentException("Kube config not found: " + filePath));
        Map<String, Object> configMap = this.loadKubeConfig(inputStream);
        return new KubeConfig(filePath, configMap);
    }

    protected KubeConfig loadKubeConfigFromInputStream(InputStream inputStream) {
        Map<String, Object> configMap = this.loadKubeConfig(inputStream);
        return new KubeConfig(configMap);
    }

    private Map<String, Object> loadKubeConfig(InputStream inputStream) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        return (Map)yaml.load(inputStream);
    }
}

