/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.config;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.util.StringUtils;
import io.micronaut.kubernetes.client.openapi.config.AbstractKubeConfigLoader;
import io.micronaut.kubernetes.client.openapi.config.KubeConfig;
import io.micronaut.kubernetes.client.openapi.config.KubernetesClientConfiguration;
import jakarta.inject.Singleton;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Singleton
@BootstrapContextCompatible
public final class DefaultKubeConfigLoader
extends AbstractKubeConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultKubeConfigLoader.class);
    private final KubernetesClientConfiguration kubernetesClientConfiguration;

    DefaultKubeConfigLoader(ResourceResolver resourceResolver, KubernetesClientConfiguration kubernetesClientConfiguration) {
        super(resourceResolver);
        this.kubernetesClientConfiguration = kubernetesClientConfiguration;
    }

    @Override
    protected KubeConfig loadKubeConfig() {
        Object kubeConfigPath = this.kubernetesClientConfiguration.getKubeConfigPath();
        if (StringUtils.isEmpty((CharSequence)kubeConfigPath)) {
            String homeDir = this.findHomeDir();
            if (StringUtils.isEmpty((CharSequence)homeDir)) {
                return null;
            }
            Path homeKubeConfigPath = Path.of(homeDir, ".kube", "config");
            if (!Files.exists(homeKubeConfigPath, new LinkOption[0])) {
                return null;
            }
            kubeConfigPath = "file:" + homeKubeConfigPath;
        }
        LOG.info("Loading kube config: {}", kubeConfigPath);
        return this.loadKubeConfigFromFile((String)kubeConfigPath);
    }

    private String findHomeDir() {
        String userProfile;
        if (System.getProperty("os.name").toLowerCase().startsWith("windows") && StringUtils.isNotEmpty((CharSequence)(userProfile = System.getenv("USERPROFILE")))) {
            return userProfile;
        }
        String envHome = System.getenv("HOME");
        return StringUtils.isEmpty((CharSequence)envHome) ? null : envHome;
    }
}

