/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.config;

import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.kubernetes.client.openapi.config.model.AuthInfo;
import io.micronaut.kubernetes.client.openapi.config.model.Cluster;
import io.micronaut.kubernetes.client.openapi.config.model.Context;
import io.micronaut.kubernetes.client.openapi.config.model.ExecConfig;
import io.micronaut.kubernetes.client.openapi.config.model.ExecEnvVar;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class KubeConfig {
    static final String REQUIRED_FIELD_ERROR_MSG = "'%s' not found in the kube config file";
    private static final String CONTEXTS_FIELD = "contexts";
    private static final String CLUSTERS_FIELD = "clusters";
    private static final String CLUSTER_FIELD = "cluster";
    private static final String USERS_FIELD = "users";
    private final Path kubeConfigParentPath;
    private final String currentContextName;
    private final Map<String, Context> contexts = new HashMap<String, Context>();
    private final Map<String, Cluster> clusters = new HashMap<String, Cluster>();
    private final Map<String, AuthInfo> users = new HashMap<String, AuthInfo>();

    public KubeConfig(Map<String, Object> configMap) {
        this(null, configMap);
    }

    public KubeConfig(String kubeConfigPath, Map<String, Object> configMap) {
        this.kubeConfigParentPath = kubeConfigPath == null ? null : (kubeConfigPath.startsWith("file:") ? Path.of(kubeConfigPath.substring(5), new String[0]).getParent() : Path.of(kubeConfigPath, new String[0]).getParent());
        String currentContext = (String)configMap.get("current-context");
        this.validateRequiredField(currentContext, "current-context", null);
        this.currentContextName = currentContext;
        List contextList = (List)configMap.get(CONTEXTS_FIELD);
        this.validateRequiredField(contextList, CONTEXTS_FIELD, null);
        contextList.forEach(obj -> {
            Map map = (Map)obj;
            this.contexts.put(this.getName(map, CONTEXTS_FIELD), this.getContext(map));
        });
        List clusterList = (List)configMap.get(CLUSTERS_FIELD);
        this.validateRequiredField(clusterList, CLUSTERS_FIELD, null);
        clusterList.forEach(obj -> {
            Map map = (Map)obj;
            this.clusters.put(this.getName(map, CLUSTERS_FIELD), this.getCluster(map));
        });
        List userList = (List)configMap.get(USERS_FIELD);
        this.validateRequiredField(userList, USERS_FIELD, null);
        userList.forEach(obj -> {
            Map map = (Map)obj;
            this.users.put(this.getName(map, USERS_FIELD), this.getUser(map));
        });
    }

    public Cluster getCluster() {
        Context currentContext = this.contexts.get(this.currentContextName);
        return this.clusters.get(currentContext.cluster());
    }

    public AuthInfo getUser() {
        Context currentContext = this.contexts.get(this.currentContextName);
        return this.users.get(currentContext.user());
    }

    public Optional<Path> getKubeConfigParentPath() {
        return Optional.ofNullable(this.kubeConfigParentPath);
    }

    public boolean isExecCommandProvided() {
        return this.getUser().exec() != null;
    }

    private String getName(Map<String, Object> map, String parentFieldName) {
        String name = (String)map.get("name");
        this.validateRequiredField(name, "name", parentFieldName);
        return name;
    }

    private Context getContext(Map<String, Object> map) {
        Map contextMap = (Map)map.get("context");
        this.validateRequiredField(contextMap, "context", CONTEXTS_FIELD);
        String cluster = (String)contextMap.get(CLUSTER_FIELD);
        this.validateRequiredField(cluster, CLUSTER_FIELD, "contexts.context");
        String user = (String)contextMap.get("user");
        this.validateRequiredField(user, "user", "contexts.context");
        String namespace = (String)contextMap.get("namespace");
        return new Context(cluster, user, namespace);
    }

    private Cluster getCluster(Map<String, Object> map) {
        Map clusterMap = (Map)map.get(CLUSTER_FIELD);
        this.validateRequiredField(clusterMap, CLUSTER_FIELD, CLUSTERS_FIELD);
        String server = (String)clusterMap.get("server");
        this.validateRequiredField(server, "server", "clusters.cluster");
        byte[] certificateAuthorityData = this.getDataBytes((String)clusterMap.get("certificate-authority-data"), (String)clusterMap.get("certificate-authority"));
        Boolean insecureSkipTlsVerify = (Boolean)clusterMap.get("insecure-skip-tls-verify");
        return new Cluster(server, certificateAuthorityData, insecureSkipTlsVerify);
    }

    private AuthInfo getUser(Map<String, Object> map) {
        Map userMap = (Map)map.get("user");
        this.validateRequiredField(userMap, "user", USERS_FIELD);
        byte[] clientCertificateData = this.getDataBytes((String)userMap.get("client-certificate-data"), (String)userMap.get("client-certificate"));
        byte[] clientKeyData = this.getDataBytes((String)userMap.get("client-key-data"), (String)userMap.get("client-key"));
        String token = this.getToken((String)userMap.get("token"), (String)userMap.get("tokenFile"));
        String username = (String)userMap.get("username");
        String password = (String)userMap.get("password");
        ExecConfig exec = this.getExecConfig(userMap);
        return new AuthInfo(clientCertificateData, clientKeyData, token, username, password, exec);
    }

    private ExecConfig getExecConfig(Map<String, Object> map) {
        Map execMap = (Map)map.get("exec");
        if (CollectionUtils.isEmpty((Map)execMap)) {
            return null;
        }
        String apiVersion = (String)execMap.get("apiVersion");
        this.validateRequiredField(execMap, "apiVersion", "users.user.exec");
        if (!"client.authentication.k8s.io/v1beta1".equals(apiVersion) && !"client.authentication.k8s.io/v1alpha1".equals(apiVersion)) {
            throw new IllegalArgumentException("Unrecognized users.user.exec.apiVersion: " + apiVersion);
        }
        String command = (String)execMap.get("command");
        this.validateRequiredField(command, "command", "users.user.exec");
        List args = (List)execMap.get("args");
        List<ExecEnvVar> env = this.getExecEnvVars(execMap);
        return new ExecConfig(apiVersion, command, args, env);
    }

    private List<ExecEnvVar> getExecEnvVars(Map<String, Object> map) {
        List envVars = (List)map.get("env");
        if (CollectionUtils.isEmpty((Collection)envVars)) {
            return null;
        }
        ArrayList<ExecEnvVar> envVarResult = new ArrayList<ExecEnvVar>(envVars.size());
        envVars.forEach(envVarMap -> {
            String name = (String)envVarMap.get("name");
            this.validateRequiredField(name, "name", "users.user.exec.env");
            String value = (String)envVarMap.get("value");
            this.validateRequiredField(name, "value", "users.user.exec.env");
            envVarResult.add(new ExecEnvVar(name, value));
        });
        return envVarResult;
    }

    private void validateRequiredField(Object field, String fieldName, String parentFieldName) {
        Map fieldMap;
        Collection fieldCollection;
        String fieldString;
        if (field == null || field instanceof String && (fieldString = (String)field).isBlank() || field instanceof Collection && (fieldCollection = (Collection)field).isEmpty() || field instanceof Map && (fieldMap = (Map)field).isEmpty()) {
            String errorField = StringUtils.isEmpty((CharSequence)parentFieldName) ? fieldName : parentFieldName + "." + fieldName;
            throw new IllegalArgumentException(REQUIRED_FIELD_ERROR_MSG.formatted(errorField));
        }
    }

    private byte[] getDataBytes(String configData, String dataRelativePath) {
        if (StringUtils.isNotEmpty((CharSequence)configData)) {
            return Base64.getDecoder().decode(configData);
        }
        if (StringUtils.isNotEmpty((CharSequence)dataRelativePath)) {
            if (this.kubeConfigParentPath == null) {
                throw new ConfigurationException("Failed to read the file whose path is relative to the kube config file path since the kube config file path not provided. The file relative path: " + dataRelativePath);
            }
            Path dataAbsolutePath = this.kubeConfigParentPath.resolve(dataRelativePath).normalize();
            try {
                return Files.readAllBytes(dataAbsolutePath);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read file: " + dataAbsolutePath, e);
            }
        }
        return null;
    }

    private String getToken(String token, String tokenFile) {
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            return token;
        }
        if (StringUtils.isNotEmpty((CharSequence)tokenFile)) {
            try {
                byte[] data = Files.readAllBytes(FileSystems.getDefault().getPath(tokenFile, new String[0]));
                return new String(data, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read token file: " + tokenFile, e);
            }
        }
        return null;
    }
}

