/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.credential;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Internal;
import io.micronaut.json.JsonMapper;
import io.micronaut.kubernetes.client.openapi.config.KubeConfig;
import io.micronaut.kubernetes.client.openapi.config.KubeConfigLoader;
import io.micronaut.kubernetes.client.openapi.config.model.ExecConfig;
import io.micronaut.kubernetes.client.openapi.config.model.ExecEnvVar;
import io.micronaut.kubernetes.client.openapi.credential.KubernetesTokenLoader;
import io.micronaut.kubernetes.client.openapi.credential.model.ExecCredential;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@BootstrapContextCompatible
@Internal
final class ExecCommandCredentialLoader
implements KubernetesTokenLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ExecCommandCredentialLoader.class);
    private static final int ORDER = 10;
    private static final Duration BUFFER = Duration.ofSeconds(60L);
    private final KubeConfig kubeConfig;
    private final JsonMapper jsonMapper;
    private volatile ExecCredential execCredential;

    ExecCommandCredentialLoader(KubeConfigLoader kubeConfigLoader, JsonMapper jsonMapper) {
        this.kubeConfig = kubeConfigLoader.getKubeConfig();
        this.jsonMapper = jsonMapper;
    }

    @Override
    public String getToken() {
        this.setExecCredential();
        return this.execCredential == null ? null : this.execCredential.status().token();
    }

    public int getOrder() {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExecCredential() {
        if (this.kubeConfig == null || !this.kubeConfig.isExecCommandProvided()) {
            return;
        }
        if (this.shouldLoadCredential()) {
            ExecCommandCredentialLoader execCommandCredentialLoader = this;
            synchronized (execCommandCredentialLoader) {
                if (this.shouldLoadCredential()) {
                    try {
                        this.execCredential = this.loadCredential();
                    }
                    catch (Exception e) {
                        LOG.error("Failed to load exec credential", (Throwable)e);
                    }
                }
            }
        }
    }

    private boolean shouldLoadCredential() {
        if (this.execCredential == null) {
            return true;
        }
        ZonedDateTime expiration = this.execCredential.status().expirationTimestamp();
        if (expiration == null) {
            return false;
        }
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
        LOG.debug("Check whether credential loading needed, now={}, buffer={}, expiration={}", new Object[]{now, BUFFER, expiration});
        return expiration.isBefore(now.plusSeconds(BUFFER.toSeconds()));
    }

    private ExecCredential loadCredential() throws Exception {
        ExecCredential execCredentialResult;
        LOG.debug("Loading credential using exec command from kube config file");
        ArrayList<String> processArgs = new ArrayList<String>();
        ExecConfig exec = this.kubeConfig.getUser().exec();
        String command = exec.command();
        if (command.contains(File.separator) && !command.startsWith(File.separator)) {
            Optional<Path> parentPath = this.kubeConfig.getKubeConfigParentPath();
            if (parentPath.isEmpty()) {
                throw new IllegalArgumentException("Failed to execute command relative to the kube config file path since the kube config file path not provided. Command: " + command);
            }
            command = parentPath.get().resolve(command).normalize().toString();
        }
        processArgs.add(command);
        List<String> args = exec.args();
        if (args != null) {
            processArgs.addAll(args);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(processArgs);
        processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        List<ExecEnvVar> env = exec.env();
        if (env != null) {
            Map<String, String> environment = processBuilder.environment();
            env.forEach(execEnvVar -> environment.put(execEnvVar.name(), execEnvVar.value()));
        }
        Process process = processBuilder.start();
        try (InputStream inputStream = process.getInputStream();){
            execCredentialResult = (ExecCredential)this.jsonMapper.readValue(inputStream, ExecCredential.class);
        }
        if (execCredentialResult.status() == null || execCredentialResult.status().token() == null) {
            throw new RuntimeException("Command '" + command + "' didn't provide token");
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new RuntimeException("Command '" + command + "' failed with exit code " + exitCode);
        }
        return execCredentialResult;
    }
}

