/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.credential;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Internal;
import io.micronaut.kubernetes.client.openapi.config.KubeConfig;
import io.micronaut.kubernetes.client.openapi.config.KubeConfigLoader;
import io.micronaut.kubernetes.client.openapi.credential.KubernetesTokenLoader;
import jakarta.inject.Singleton;

@Singleton
@BootstrapContextCompatible
@Internal
final class KubeConfigTokenLoader
implements KubernetesTokenLoader {
    private static final int ORDER = 20;
    private final String token;

    KubeConfigTokenLoader(KubeConfigLoader kubeConfigLoader) {
        KubeConfig kubeConfig = kubeConfigLoader.getKubeConfig();
        this.token = kubeConfig == null || kubeConfig.getUser() == null ? null : kubeConfig.getUser().token();
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public int getOrder() {
        return 20;
    }
}

