/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.credential;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.kubernetes.client.openapi.config.KubernetesClientConfiguration;
import io.micronaut.kubernetes.client.openapi.credential.KubernetesTokenLoader;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@BootstrapContextCompatible
@Internal
@Requires(property="kubernetes.client.service-account.enabled", value="true", defaultValue="true")
final class ServiceAccountTokenLoader
implements KubernetesTokenLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceAccountTokenLoader.class);
    private static final int ORDER = 30;
    private final ResourceResolver resourceResolver;
    private final KubernetesClientConfiguration.ServiceAccount serviceAccount;
    private volatile String token;
    private volatile LocalDateTime expirationTime;

    ServiceAccountTokenLoader(ResourceResolver resourceResolver, KubernetesClientConfiguration kubernetesClientConfiguration) {
        this.resourceResolver = resourceResolver;
        this.serviceAccount = kubernetesClientConfiguration.getServiceAccount();
    }

    @Override
    public String getToken() {
        this.setToken();
        return this.token;
    }

    public int getOrder() {
        return 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setToken() {
        if (this.shouldLoadToken()) {
            ServiceAccountTokenLoader serviceAccountTokenLoader = this;
            synchronized (serviceAccountTokenLoader) {
                if (this.shouldLoadToken()) {
                    String tokenPath = this.serviceAccount.getTokenPath();
                    Duration tokenReloadInterval = this.serviceAccount.getTokenReloadInterval();
                    try {
                        this.token = this.loadToken(tokenPath);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to load service account token from file: " + tokenPath, e);
                    }
                    this.expirationTime = LocalDateTime.now().plusSeconds(tokenReloadInterval.toSeconds());
                }
            }
        }
    }

    private boolean shouldLoadToken() {
        if (this.token == null || this.expirationTime == null) {
            return true;
        }
        LocalDateTime now = LocalDateTime.now();
        LOG.debug("Check whether token reloading needed, now={}, expiration={}", (Object)now, (Object)this.expirationTime);
        return this.expirationTime.isBefore(now);
    }

    private String loadToken(String tokenPath) throws IOException {
        LOG.debug("Loading token from file: {}", (Object)tokenPath);
        Optional inputStreamOpt = this.resourceResolver.getResourceAsStream(tokenPath);
        if (inputStreamOpt.isEmpty()) {
            throw new ConfigurationException("Token file not found: " + tokenPath);
        }
        InputStream inputStream = (InputStream)inputStreamOpt.get();
        return new String(inputStream.readAllBytes());
    }
}

