/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.kubernetes.client.openapi.model.V1TokenRequestSpec;
import io.micronaut.kubernetes.client.openapi.model.V1TokenRequestStatus;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"spec", "apiVersion", "kind", "metadata", "status"})
public class AuthenticationV1TokenRequest {
    public static final String JSON_PROPERTY_SPEC = "spec";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    public static final String JSON_PROPERTY_STATUS = "status";
    @NotNull
    @Valid
    @JsonProperty(value="spec")
    private V1TokenRequestSpec spec;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;
    @Nullable
    @Valid
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1TokenRequestStatus status;

    public AuthenticationV1TokenRequest(V1TokenRequestSpec spec) {
        this.spec = spec;
    }

    public V1TokenRequestSpec getSpec() {
        return this.spec;
    }

    public void setSpec(V1TokenRequestSpec spec) {
        this.spec = spec;
    }

    public AuthenticationV1TokenRequest spec(V1TokenRequestSpec spec) {
        this.spec = spec;
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public AuthenticationV1TokenRequest apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public AuthenticationV1TokenRequest kind(String kind) {
        this.kind = kind;
        return this;
    }

    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public AuthenticationV1TokenRequest metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public V1TokenRequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(V1TokenRequestStatus status) {
        this.status = status;
    }

    public AuthenticationV1TokenRequest status(V1TokenRequestStatus status) {
        this.status = status;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationV1TokenRequest authenticationV1TokenRequest = (AuthenticationV1TokenRequest)o;
        return Objects.equals(this.spec, authenticationV1TokenRequest.spec) && Objects.equals(this.apiVersion, authenticationV1TokenRequest.apiVersion) && Objects.equals(this.kind, authenticationV1TokenRequest.kind) && Objects.equals(this.metadata, authenticationV1TokenRequest.metadata) && Objects.equals(this.status, authenticationV1TokenRequest.status);
    }

    public int hashCode() {
        return Objects.hash(this.spec, this.apiVersion, this.kind, this.metadata, this.status);
    }

    public String toString() {
        return "AuthenticationV1TokenRequest(spec: " + this.getSpec() + ", apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ", metadata: " + this.getMetadata() + ", status: " + this.getStatus() + ")";
    }
}

