/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1APIResource;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"groupVersion", "resources", "apiVersion", "kind"})
public class V1APIResourceList {
    public static final String JSON_PROPERTY_GROUP_VERSION = "groupVersion";
    public static final String JSON_PROPERTY_RESOURCES = "resources";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    @NotNull
    @JsonProperty(value="groupVersion")
    private String groupVersion;
    @NotNull
    @JsonProperty(value="resources")
    private @NotNull List<@Valid V1APIResource> resources;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;

    public V1APIResourceList(String groupVersion, List<@Valid V1APIResource> resources) {
        this.groupVersion = groupVersion;
        this.resources = resources;
    }

    public String getGroupVersion() {
        return this.groupVersion;
    }

    public void setGroupVersion(String groupVersion) {
        this.groupVersion = groupVersion;
    }

    public V1APIResourceList groupVersion(String groupVersion) {
        this.groupVersion = groupVersion;
        return this;
    }

    public List<@Valid V1APIResource> getResources() {
        return this.resources;
    }

    public void setResources(List<@Valid V1APIResource> resources) {
        this.resources = resources;
    }

    public V1APIResourceList resources(List<@Valid V1APIResource> resources) {
        this.resources = resources;
        return this;
    }

    public V1APIResourceList addresourcesItem(V1APIResource resourcesItem) {
        this.resources.add(resourcesItem);
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1APIResourceList apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1APIResourceList kind(String kind) {
        this.kind = kind;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIResourceList v1APIResourceList = (V1APIResourceList)o;
        return Objects.equals(this.groupVersion, v1APIResourceList.groupVersion) && Objects.equals(this.resources, v1APIResourceList.resources) && Objects.equals(this.apiVersion, v1APIResourceList.apiVersion) && Objects.equals(this.kind, v1APIResourceList.kind);
    }

    public int hashCode() {
        return Objects.hash(this.groupVersion, this.resources, this.apiVersion, this.kind);
    }

    public String toString() {
        return "V1APIResourceList(groupVersion: " + this.getGroupVersion() + ", resources: " + this.getResources() + ", apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ")";
    }
}

