/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1DeploymentStrategy;
import io.micronaut.kubernetes.client.openapi.model.V1LabelSelector;
import io.micronaut.kubernetes.client.openapi.model.V1PodTemplateSpec;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"selector", "template", "minReadySeconds", "paused", "progressDeadlineSeconds", "replicas", "revisionHistoryLimit", "strategy"})
public class V1DeploymentSpec {
    public static final String JSON_PROPERTY_SELECTOR = "selector";
    public static final String JSON_PROPERTY_TEMPLATE = "template";
    public static final String JSON_PROPERTY_MIN_READY_SECONDS = "minReadySeconds";
    public static final String JSON_PROPERTY_PAUSED = "paused";
    public static final String JSON_PROPERTY_PROGRESS_DEADLINE_SECONDS = "progressDeadlineSeconds";
    public static final String JSON_PROPERTY_REPLICAS = "replicas";
    public static final String JSON_PROPERTY_REVISION_HISTORY_LIMIT = "revisionHistoryLimit";
    public static final String JSON_PROPERTY_STRATEGY = "strategy";
    @NotNull
    @Valid
    @JsonProperty(value="selector")
    private V1LabelSelector selector;
    @NotNull
    @Valid
    @JsonProperty(value="template")
    private V1PodTemplateSpec template;
    @Nullable
    @JsonProperty(value="minReadySeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer minReadySeconds;
    @Nullable
    @JsonProperty(value="paused")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean paused;
    @Nullable
    @JsonProperty(value="progressDeadlineSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer progressDeadlineSeconds;
    @Nullable
    @JsonProperty(value="replicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer replicas;
    @Nullable
    @JsonProperty(value="revisionHistoryLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer revisionHistoryLimit;
    @Nullable
    @Valid
    @JsonProperty(value="strategy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1DeploymentStrategy strategy;

    public V1DeploymentSpec(V1LabelSelector selector, V1PodTemplateSpec template) {
        this.selector = selector;
        this.template = template;
    }

    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1DeploymentSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public V1DeploymentSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public void setMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
    }

    public V1DeploymentSpec minReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return this;
    }

    public Boolean getPaused() {
        return this.paused;
    }

    public void setPaused(Boolean paused) {
        this.paused = paused;
    }

    public V1DeploymentSpec paused(Boolean paused) {
        this.paused = paused;
        return this;
    }

    public Integer getProgressDeadlineSeconds() {
        return this.progressDeadlineSeconds;
    }

    public void setProgressDeadlineSeconds(Integer progressDeadlineSeconds) {
        this.progressDeadlineSeconds = progressDeadlineSeconds;
    }

    public V1DeploymentSpec progressDeadlineSeconds(Integer progressDeadlineSeconds) {
        this.progressDeadlineSeconds = progressDeadlineSeconds;
        return this;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1DeploymentSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public void setRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
    }

    public V1DeploymentSpec revisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return this;
    }

    public V1DeploymentStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(V1DeploymentStrategy strategy) {
        this.strategy = strategy;
    }

    public V1DeploymentSpec strategy(V1DeploymentStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1DeploymentSpec v1DeploymentSpec = (V1DeploymentSpec)o;
        return Objects.equals(this.selector, v1DeploymentSpec.selector) && Objects.equals(this.template, v1DeploymentSpec.template) && Objects.equals(this.minReadySeconds, v1DeploymentSpec.minReadySeconds) && Objects.equals(this.paused, v1DeploymentSpec.paused) && Objects.equals(this.progressDeadlineSeconds, v1DeploymentSpec.progressDeadlineSeconds) && Objects.equals(this.replicas, v1DeploymentSpec.replicas) && Objects.equals(this.revisionHistoryLimit, v1DeploymentSpec.revisionHistoryLimit) && Objects.equals(this.strategy, v1DeploymentSpec.strategy);
    }

    public int hashCode() {
        return Objects.hash(this.selector, this.template, this.minReadySeconds, this.paused, this.progressDeadlineSeconds, this.replicas, this.revisionHistoryLimit, this.strategy);
    }

    public String toString() {
        return "V1DeploymentSpec(selector: " + this.getSelector() + ", template: " + this.getTemplate() + ", minReadySeconds: " + this.getMinReadySeconds() + ", paused: " + this.getPaused() + ", progressDeadlineSeconds: " + this.getProgressDeadlineSeconds() + ", replicas: " + this.getReplicas() + ", revisionHistoryLimit: " + this.getRevisionHistoryLimit() + ", strategy: " + this.getStrategy() + ")";
    }
}

