/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.DiscoveryV1EndpointPort;
import io.micronaut.kubernetes.client.openapi.model.V1Endpoint;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"addressType", "endpoints", "apiVersion", "kind", "metadata", "ports"})
public class V1EndpointSlice {
    public static final String JSON_PROPERTY_ADDRESS_TYPE = "addressType";
    public static final String JSON_PROPERTY_ENDPOINTS = "endpoints";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    public static final String JSON_PROPERTY_PORTS = "ports";
    @NotNull
    @JsonProperty(value="addressType")
    private String addressType;
    @NotNull
    @JsonProperty(value="endpoints")
    private @NotNull List<@Valid V1Endpoint> endpoints;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;
    @Nullable
    @JsonProperty(value="ports")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid DiscoveryV1EndpointPort> ports;

    public V1EndpointSlice(String addressType, List<@Valid V1Endpoint> endpoints) {
        this.addressType = addressType;
        this.endpoints = endpoints;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public V1EndpointSlice addressType(String addressType) {
        this.addressType = addressType;
        return this;
    }

    public List<@Valid V1Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<@Valid V1Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public V1EndpointSlice endpoints(List<@Valid V1Endpoint> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public V1EndpointSlice addendpointsItem(V1Endpoint endpointsItem) {
        this.endpoints.add(endpointsItem);
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1EndpointSlice apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1EndpointSlice kind(String kind) {
        this.kind = kind;
        return this;
    }

    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1EndpointSlice metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<@Valid DiscoveryV1EndpointPort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<@Valid DiscoveryV1EndpointPort> ports) {
        this.ports = ports;
    }

    public V1EndpointSlice ports(List<@Valid DiscoveryV1EndpointPort> ports) {
        this.ports = ports;
        return this;
    }

    public V1EndpointSlice addportsItem(DiscoveryV1EndpointPort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<DiscoveryV1EndpointPort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EndpointSlice v1EndpointSlice = (V1EndpointSlice)o;
        return Objects.equals(this.addressType, v1EndpointSlice.addressType) && Objects.equals(this.endpoints, v1EndpointSlice.endpoints) && Objects.equals(this.apiVersion, v1EndpointSlice.apiVersion) && Objects.equals(this.kind, v1EndpointSlice.kind) && Objects.equals(this.metadata, v1EndpointSlice.metadata) && Objects.equals(this.ports, v1EndpointSlice.ports);
    }

    public int hashCode() {
        return Objects.hash(this.addressType, this.endpoints, this.apiVersion, this.kind, this.metadata, this.ports);
    }

    public String toString() {
        return "V1EndpointSlice(addressType: " + this.getAddressType() + ", endpoints: " + this.getEndpoints() + ", apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ", metadata: " + this.getMetadata() + ", ports: " + this.getPorts() + ")";
    }
}

