/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1SecretReference;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"driver", "fsType", "options", "readOnly", "secretRef"})
public class V1FlexPersistentVolumeSource {
    public static final String JSON_PROPERTY_DRIVER = "driver";
    public static final String JSON_PROPERTY_FS_TYPE = "fsType";
    public static final String JSON_PROPERTY_OPTIONS = "options";
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    public static final String JSON_PROPERTY_SECRET_REF = "secretRef";
    @NotNull
    @JsonProperty(value="driver")
    private String driver;
    @Nullable
    @JsonProperty(value="fsType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String fsType;
    @Nullable
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> options;
    @Nullable
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean readOnly;
    @Nullable
    @Valid
    @JsonProperty(value="secretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1SecretReference secretRef;

    public V1FlexPersistentVolumeSource(String driver) {
        this.driver = driver;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public V1FlexPersistentVolumeSource driver(String driver) {
        this.driver = driver;
        return this;
    }

    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1FlexPersistentVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    public Map<String, @NotNull String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, @NotNull String> options) {
        this.options = options;
    }

    public V1FlexPersistentVolumeSource options(Map<String, @NotNull String> options) {
        this.options = options;
        return this;
    }

    public V1FlexPersistentVolumeSource putoptionsItem(String key, String optionsItem) {
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
        this.options.put(key, optionsItem);
        return this;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1FlexPersistentVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public V1SecretReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(V1SecretReference secretRef) {
        this.secretRef = secretRef;
    }

    public V1FlexPersistentVolumeSource secretRef(V1SecretReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1FlexPersistentVolumeSource v1FlexPersistentVolumeSource = (V1FlexPersistentVolumeSource)o;
        return Objects.equals(this.driver, v1FlexPersistentVolumeSource.driver) && Objects.equals(this.fsType, v1FlexPersistentVolumeSource.fsType) && Objects.equals(this.options, v1FlexPersistentVolumeSource.options) && Objects.equals(this.readOnly, v1FlexPersistentVolumeSource.readOnly) && Objects.equals(this.secretRef, v1FlexPersistentVolumeSource.secretRef);
    }

    public int hashCode() {
        return Objects.hash(this.driver, this.fsType, this.options, this.readOnly, this.secretRef);
    }

    public String toString() {
        return "V1FlexPersistentVolumeSource(driver: " + this.getDriver() + ", fsType: " + this.getFsType() + ", options: " + this.getOptions() + ", readOnly: " + this.getReadOnly() + ", secretRef: " + this.getSecretRef() + ")";
    }
}

