/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1LimitRange;
import io.micronaut.kubernetes.client.openapi.model.V1ListMeta;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"items", "apiVersion", "kind", "metadata"})
public class V1LimitRangeList {
    public static final String JSON_PROPERTY_ITEMS = "items";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    @NotNull
    @JsonProperty(value="items")
    private @NotNull List<@Valid V1LimitRange> items;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ListMeta metadata;

    public V1LimitRangeList(List<@Valid V1LimitRange> items) {
        this.items = items;
    }

    public List<@Valid V1LimitRange> getItems() {
        return this.items;
    }

    public void setItems(List<@Valid V1LimitRange> items) {
        this.items = items;
    }

    public V1LimitRangeList items(List<@Valid V1LimitRange> items) {
        this.items = items;
        return this;
    }

    public V1LimitRangeList additemsItem(V1LimitRange itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1LimitRangeList apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1LimitRangeList kind(String kind) {
        this.kind = kind;
        return this;
    }

    public V1ListMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ListMeta metadata) {
        this.metadata = metadata;
    }

    public V1LimitRangeList metadata(V1ListMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LimitRangeList v1LimitRangeList = (V1LimitRangeList)o;
        return Objects.equals(this.items, v1LimitRangeList.items) && Objects.equals(this.apiVersion, v1LimitRangeList.apiVersion) && Objects.equals(this.kind, v1LimitRangeList.kind) && Objects.equals(this.metadata, v1LimitRangeList.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.apiVersion, this.kind, this.metadata);
    }

    public String toString() {
        return "V1LimitRangeList(items: " + this.getItems() + ", apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ", metadata: " + this.getMetadata() + ")";
    }
}

