/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"apiVersion", "kind", "name", "uid", "blockOwnerDeletion", "controller"})
public class V1OwnerReference {
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_NAME = "name";
    public static final String JSON_PROPERTY_UID = "uid";
    public static final String JSON_PROPERTY_BLOCK_OWNER_DELETION = "blockOwnerDeletion";
    public static final String JSON_PROPERTY_CONTROLLER = "controller";
    @NotNull
    @JsonProperty(value="apiVersion")
    private String apiVersion;
    @NotNull
    @JsonProperty(value="kind")
    private String kind;
    @NotNull
    @JsonProperty(value="name")
    private String name;
    @NotNull
    @JsonProperty(value="uid")
    private String uid;
    @Nullable
    @JsonProperty(value="blockOwnerDeletion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean blockOwnerDeletion;
    @Nullable
    @JsonProperty(value="controller")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean controller;

    public V1OwnerReference(String apiVersion, String kind, String name, String uid) {
        this.apiVersion = apiVersion;
        this.kind = kind;
        this.name = name;
        this.uid = uid;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1OwnerReference apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1OwnerReference kind(String kind) {
        this.kind = kind;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1OwnerReference name(String name) {
        this.name = name;
        return this;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public V1OwnerReference uid(String uid) {
        this.uid = uid;
        return this;
    }

    public Boolean getBlockOwnerDeletion() {
        return this.blockOwnerDeletion;
    }

    public void setBlockOwnerDeletion(Boolean blockOwnerDeletion) {
        this.blockOwnerDeletion = blockOwnerDeletion;
    }

    public V1OwnerReference blockOwnerDeletion(Boolean blockOwnerDeletion) {
        this.blockOwnerDeletion = blockOwnerDeletion;
        return this;
    }

    public Boolean getController() {
        return this.controller;
    }

    public void setController(Boolean controller) {
        this.controller = controller;
    }

    public V1OwnerReference controller(Boolean controller) {
        this.controller = controller;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1OwnerReference v1OwnerReference = (V1OwnerReference)o;
        return Objects.equals(this.apiVersion, v1OwnerReference.apiVersion) && Objects.equals(this.kind, v1OwnerReference.kind) && Objects.equals(this.name, v1OwnerReference.name) && Objects.equals(this.uid, v1OwnerReference.uid) && Objects.equals(this.blockOwnerDeletion, v1OwnerReference.blockOwnerDeletion) && Objects.equals(this.controller, v1OwnerReference.controller);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.name, this.uid, this.blockOwnerDeletion, this.controller);
    }

    public String toString() {
        return "V1OwnerReference(apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ", name: " + this.getName() + ", uid: " + this.getUid() + ", blockOwnerDeletion: " + this.getBlockOwnerDeletion() + ", controller: " + this.getController() + ")";
    }
}

