/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1LabelSelector;
import io.micronaut.kubernetes.client.openapi.model.V1ResourceRequirements;
import io.micronaut.kubernetes.client.openapi.model.V1TypedLocalObjectReference;
import io.micronaut.kubernetes.client.openapi.model.V1TypedObjectReference;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"accessModes", "dataSource", "dataSourceRef", "resources", "selector", "storageClassName", "volumeMode", "volumeName"})
public class V1PersistentVolumeClaimSpec {
    public static final String JSON_PROPERTY_ACCESS_MODES = "accessModes";
    public static final String JSON_PROPERTY_DATA_SOURCE = "dataSource";
    public static final String JSON_PROPERTY_DATA_SOURCE_REF = "dataSourceRef";
    public static final String JSON_PROPERTY_RESOURCES = "resources";
    public static final String JSON_PROPERTY_SELECTOR = "selector";
    public static final String JSON_PROPERTY_STORAGE_CLASS_NAME = "storageClassName";
    public static final String JSON_PROPERTY_VOLUME_MODE = "volumeMode";
    public static final String JSON_PROPERTY_VOLUME_NAME = "volumeName";
    @Nullable
    @JsonProperty(value="accessModes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> accessModes;
    @Nullable
    @Valid
    @JsonProperty(value="dataSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1TypedLocalObjectReference dataSource;
    @Nullable
    @Valid
    @JsonProperty(value="dataSourceRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1TypedObjectReference dataSourceRef;
    @Nullable
    @Valid
    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ResourceRequirements resources;
    @Nullable
    @Valid
    @JsonProperty(value="selector")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1LabelSelector selector;
    @Nullable
    @JsonProperty(value="storageClassName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String storageClassName;
    @Nullable
    @JsonProperty(value="volumeMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String volumeMode;
    @Nullable
    @JsonProperty(value="volumeName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String volumeName;

    public List<@NotNull String> getAccessModes() {
        return this.accessModes;
    }

    public void setAccessModes(List<@NotNull String> accessModes) {
        this.accessModes = accessModes;
    }

    public V1PersistentVolumeClaimSpec accessModes(List<@NotNull String> accessModes) {
        this.accessModes = accessModes;
        return this;
    }

    public V1PersistentVolumeClaimSpec addaccessModesItem(String accessModesItem) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(accessModesItem);
        return this;
    }

    public V1TypedLocalObjectReference getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(V1TypedLocalObjectReference dataSource) {
        this.dataSource = dataSource;
    }

    public V1PersistentVolumeClaimSpec dataSource(V1TypedLocalObjectReference dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public V1TypedObjectReference getDataSourceRef() {
        return this.dataSourceRef;
    }

    public void setDataSourceRef(V1TypedObjectReference dataSourceRef) {
        this.dataSourceRef = dataSourceRef;
    }

    public V1PersistentVolumeClaimSpec dataSourceRef(V1TypedObjectReference dataSourceRef) {
        this.dataSourceRef = dataSourceRef;
        return this;
    }

    public V1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(V1ResourceRequirements resources) {
        this.resources = resources;
    }

    public V1PersistentVolumeClaimSpec resources(V1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1PersistentVolumeClaimSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    public String getStorageClassName() {
        return this.storageClassName;
    }

    public void setStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
    }

    public V1PersistentVolumeClaimSpec storageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return this;
    }

    public String getVolumeMode() {
        return this.volumeMode;
    }

    public void setVolumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
    }

    public V1PersistentVolumeClaimSpec volumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
        return this;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public V1PersistentVolumeClaimSpec volumeName(String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PersistentVolumeClaimSpec v1PersistentVolumeClaimSpec = (V1PersistentVolumeClaimSpec)o;
        return Objects.equals(this.accessModes, v1PersistentVolumeClaimSpec.accessModes) && Objects.equals(this.dataSource, v1PersistentVolumeClaimSpec.dataSource) && Objects.equals(this.dataSourceRef, v1PersistentVolumeClaimSpec.dataSourceRef) && Objects.equals(this.resources, v1PersistentVolumeClaimSpec.resources) && Objects.equals(this.selector, v1PersistentVolumeClaimSpec.selector) && Objects.equals(this.storageClassName, v1PersistentVolumeClaimSpec.storageClassName) && Objects.equals(this.volumeMode, v1PersistentVolumeClaimSpec.volumeMode) && Objects.equals(this.volumeName, v1PersistentVolumeClaimSpec.volumeName);
    }

    public int hashCode() {
        return Objects.hash(this.accessModes, this.dataSource, this.dataSourceRef, this.resources, this.selector, this.storageClassName, this.volumeMode, this.volumeName);
    }

    public String toString() {
        return "V1PersistentVolumeClaimSpec(accessModes: " + this.getAccessModes() + ", dataSource: " + this.getDataSource() + ", dataSourceRef: " + this.getDataSourceRef() + ", resources: " + this.getResources() + ", selector: " + this.getSelector() + ", storageClassName: " + this.getStorageClassName() + ", volumeMode: " + this.getVolumeMode() + ", volumeName: " + this.getVolumeName() + ")";
    }
}

