/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1ContainerStatus;
import io.micronaut.kubernetes.client.openapi.model.V1PodCondition;
import io.micronaut.kubernetes.client.openapi.model.V1PodIP;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"conditions", "containerStatuses", "ephemeralContainerStatuses", "hostIP", "initContainerStatuses", "message", "nominatedNodeName", "phase", "podIP", "podIPs", "qosClass", "reason", "resize", "startTime"})
public class V1PodStatus {
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    public static final String JSON_PROPERTY_CONTAINER_STATUSES = "containerStatuses";
    public static final String JSON_PROPERTY_EPHEMERAL_CONTAINER_STATUSES = "ephemeralContainerStatuses";
    public static final String JSON_PROPERTY_HOST_I_P = "hostIP";
    public static final String JSON_PROPERTY_INIT_CONTAINER_STATUSES = "initContainerStatuses";
    public static final String JSON_PROPERTY_MESSAGE = "message";
    public static final String JSON_PROPERTY_NOMINATED_NODE_NAME = "nominatedNodeName";
    public static final String JSON_PROPERTY_PHASE = "phase";
    public static final String JSON_PROPERTY_POD_I_P = "podIP";
    public static final String JSON_PROPERTY_POD_I_PS = "podIPs";
    public static final String JSON_PROPERTY_QOS_CLASS = "qosClass";
    public static final String JSON_PROPERTY_REASON = "reason";
    public static final String JSON_PROPERTY_RESIZE = "resize";
    public static final String JSON_PROPERTY_START_TIME = "startTime";
    @Nullable
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1PodCondition> conditions;
    @Nullable
    @JsonProperty(value="containerStatuses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1ContainerStatus> containerStatuses;
    @Nullable
    @JsonProperty(value="ephemeralContainerStatuses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1ContainerStatus> ephemeralContainerStatuses;
    @Nullable
    @JsonProperty(value="hostIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String hostIP;
    @Nullable
    @JsonProperty(value="initContainerStatuses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1ContainerStatus> initContainerStatuses;
    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String message;
    @Nullable
    @JsonProperty(value="nominatedNodeName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String nominatedNodeName;
    @Nullable
    @JsonProperty(value="phase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String phase;
    @Nullable
    @JsonProperty(value="podIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String podIP;
    @Nullable
    @JsonProperty(value="podIPs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1PodIP> podIPs;
    @Nullable
    @JsonProperty(value="qosClass")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String qosClass;
    @Nullable
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String reason;
    @Nullable
    @JsonProperty(value="resize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String resize;
    @Nullable
    @JsonProperty(value="startTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private ZonedDateTime startTime;

    public List<@Valid V1PodCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<@Valid V1PodCondition> conditions) {
        this.conditions = conditions;
    }

    public V1PodStatus conditions(List<@Valid V1PodCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1PodStatus addconditionsItem(V1PodCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1PodCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    public List<@Valid V1ContainerStatus> getContainerStatuses() {
        return this.containerStatuses;
    }

    public void setContainerStatuses(List<@Valid V1ContainerStatus> containerStatuses) {
        this.containerStatuses = containerStatuses;
    }

    public V1PodStatus containerStatuses(List<@Valid V1ContainerStatus> containerStatuses) {
        this.containerStatuses = containerStatuses;
        return this;
    }

    public V1PodStatus addcontainerStatusesItem(V1ContainerStatus containerStatusesItem) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<V1ContainerStatus>();
        }
        this.containerStatuses.add(containerStatusesItem);
        return this;
    }

    public List<@Valid V1ContainerStatus> getEphemeralContainerStatuses() {
        return this.ephemeralContainerStatuses;
    }

    public void setEphemeralContainerStatuses(List<@Valid V1ContainerStatus> ephemeralContainerStatuses) {
        this.ephemeralContainerStatuses = ephemeralContainerStatuses;
    }

    public V1PodStatus ephemeralContainerStatuses(List<@Valid V1ContainerStatus> ephemeralContainerStatuses) {
        this.ephemeralContainerStatuses = ephemeralContainerStatuses;
        return this;
    }

    public V1PodStatus addephemeralContainerStatusesItem(V1ContainerStatus ephemeralContainerStatusesItem) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList<V1ContainerStatus>();
        }
        this.ephemeralContainerStatuses.add(ephemeralContainerStatusesItem);
        return this;
    }

    public String getHostIP() {
        return this.hostIP;
    }

    public void setHostIP(String hostIP) {
        this.hostIP = hostIP;
    }

    public V1PodStatus hostIP(String hostIP) {
        this.hostIP = hostIP;
        return this;
    }

    public List<@Valid V1ContainerStatus> getInitContainerStatuses() {
        return this.initContainerStatuses;
    }

    public void setInitContainerStatuses(List<@Valid V1ContainerStatus> initContainerStatuses) {
        this.initContainerStatuses = initContainerStatuses;
    }

    public V1PodStatus initContainerStatuses(List<@Valid V1ContainerStatus> initContainerStatuses) {
        this.initContainerStatuses = initContainerStatuses;
        return this;
    }

    public V1PodStatus addinitContainerStatusesItem(V1ContainerStatus initContainerStatusesItem) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList<V1ContainerStatus>();
        }
        this.initContainerStatuses.add(initContainerStatusesItem);
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V1PodStatus message(String message) {
        this.message = message;
        return this;
    }

    public String getNominatedNodeName() {
        return this.nominatedNodeName;
    }

    public void setNominatedNodeName(String nominatedNodeName) {
        this.nominatedNodeName = nominatedNodeName;
    }

    public V1PodStatus nominatedNodeName(String nominatedNodeName) {
        this.nominatedNodeName = nominatedNodeName;
        return this;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public V1PodStatus phase(String phase) {
        this.phase = phase;
        return this;
    }

    public String getPodIP() {
        return this.podIP;
    }

    public void setPodIP(String podIP) {
        this.podIP = podIP;
    }

    public V1PodStatus podIP(String podIP) {
        this.podIP = podIP;
        return this;
    }

    public List<@Valid V1PodIP> getPodIPs() {
        return this.podIPs;
    }

    public void setPodIPs(List<@Valid V1PodIP> podIPs) {
        this.podIPs = podIPs;
    }

    public V1PodStatus podIPs(List<@Valid V1PodIP> podIPs) {
        this.podIPs = podIPs;
        return this;
    }

    public V1PodStatus addpodIPsItem(V1PodIP podIPsItem) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList<V1PodIP>();
        }
        this.podIPs.add(podIPsItem);
        return this;
    }

    public String getQosClass() {
        return this.qosClass;
    }

    public void setQosClass(String qosClass) {
        this.qosClass = qosClass;
    }

    public V1PodStatus qosClass(String qosClass) {
        this.qosClass = qosClass;
        return this;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1PodStatus reason(String reason) {
        this.reason = reason;
        return this;
    }

    public String getResize() {
        return this.resize;
    }

    public void setResize(String resize) {
        this.resize = resize;
    }

    public V1PodStatus resize(String resize) {
        this.resize = resize;
        return this;
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(ZonedDateTime startTime) {
        this.startTime = startTime;
    }

    public V1PodStatus startTime(ZonedDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodStatus v1PodStatus = (V1PodStatus)o;
        return Objects.equals(this.conditions, v1PodStatus.conditions) && Objects.equals(this.containerStatuses, v1PodStatus.containerStatuses) && Objects.equals(this.ephemeralContainerStatuses, v1PodStatus.ephemeralContainerStatuses) && Objects.equals(this.hostIP, v1PodStatus.hostIP) && Objects.equals(this.initContainerStatuses, v1PodStatus.initContainerStatuses) && Objects.equals(this.message, v1PodStatus.message) && Objects.equals(this.nominatedNodeName, v1PodStatus.nominatedNodeName) && Objects.equals(this.phase, v1PodStatus.phase) && Objects.equals(this.podIP, v1PodStatus.podIP) && Objects.equals(this.podIPs, v1PodStatus.podIPs) && Objects.equals(this.qosClass, v1PodStatus.qosClass) && Objects.equals(this.reason, v1PodStatus.reason) && Objects.equals(this.resize, v1PodStatus.resize) && Objects.equals(this.startTime, v1PodStatus.startTime);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.containerStatuses, this.ephemeralContainerStatuses, this.hostIP, this.initContainerStatuses, this.message, this.nominatedNodeName, this.phase, this.podIP, this.podIPs, this.qosClass, this.reason, this.resize, this.startTime);
    }

    public String toString() {
        return "V1PodStatus(conditions: " + this.getConditions() + ", containerStatuses: " + this.getContainerStatuses() + ", ephemeralContainerStatuses: " + this.getEphemeralContainerStatuses() + ", hostIP: " + this.getHostIP() + ", initContainerStatuses: " + this.getInitContainerStatuses() + ", message: " + this.getMessage() + ", nominatedNodeName: " + this.getNominatedNodeName() + ", phase: " + this.getPhase() + ", podIP: " + this.getPodIP() + ", podIPs: " + this.getPodIPs() + ", qosClass: " + this.getQosClass() + ", reason: " + this.getReason() + ", resize: " + this.getResize() + ", startTime: " + this.getStartTime() + ")";
    }
}

