/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.kubernetes.client.openapi.model.V1RoleRef;
import io.micronaut.kubernetes.client.openapi.model.V1Subject;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"roleRef", "apiVersion", "kind", "metadata", "subjects"})
public class V1RoleBinding {
    public static final String JSON_PROPERTY_ROLE_REF = "roleRef";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    public static final String JSON_PROPERTY_SUBJECTS = "subjects";
    @NotNull
    @Valid
    @JsonProperty(value="roleRef")
    private V1RoleRef roleRef;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;
    @Nullable
    @JsonProperty(value="subjects")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1Subject> subjects;

    public V1RoleBinding(V1RoleRef roleRef) {
        this.roleRef = roleRef;
    }

    public V1RoleRef getRoleRef() {
        return this.roleRef;
    }

    public void setRoleRef(V1RoleRef roleRef) {
        this.roleRef = roleRef;
    }

    public V1RoleBinding roleRef(V1RoleRef roleRef) {
        this.roleRef = roleRef;
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1RoleBinding apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1RoleBinding kind(String kind) {
        this.kind = kind;
        return this;
    }

    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1RoleBinding metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<@Valid V1Subject> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<@Valid V1Subject> subjects) {
        this.subjects = subjects;
    }

    public V1RoleBinding subjects(List<@Valid V1Subject> subjects) {
        this.subjects = subjects;
        return this;
    }

    public V1RoleBinding addsubjectsItem(V1Subject subjectsItem) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<V1Subject>();
        }
        this.subjects.add(subjectsItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1RoleBinding v1RoleBinding = (V1RoleBinding)o;
        return Objects.equals(this.roleRef, v1RoleBinding.roleRef) && Objects.equals(this.apiVersion, v1RoleBinding.apiVersion) && Objects.equals(this.kind, v1RoleBinding.kind) && Objects.equals(this.metadata, v1RoleBinding.metadata) && Objects.equals(this.subjects, v1RoleBinding.subjects);
    }

    public int hashCode() {
        return Objects.hash(this.roleRef, this.apiVersion, this.kind, this.metadata, this.subjects);
    }

    public String toString() {
        return "V1RoleBinding(roleRef: " + this.getRoleRef() + ", apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ", metadata: " + this.getMetadata() + ", subjects: " + this.getSubjects() + ")";
    }
}

