/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"apiGroups", "apiVersions", "operations", "resources", "scope"})
public class V1RuleWithOperations {
    public static final String JSON_PROPERTY_API_GROUPS = "apiGroups";
    public static final String JSON_PROPERTY_API_VERSIONS = "apiVersions";
    public static final String JSON_PROPERTY_OPERATIONS = "operations";
    public static final String JSON_PROPERTY_RESOURCES = "resources";
    public static final String JSON_PROPERTY_SCOPE = "scope";
    @Nullable
    @JsonProperty(value="apiGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> apiGroups;
    @Nullable
    @JsonProperty(value="apiVersions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> apiVersions;
    @Nullable
    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> operations;
    @Nullable
    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> resources;
    @Nullable
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String scope;

    public List<@NotNull String> getApiGroups() {
        return this.apiGroups;
    }

    public void setApiGroups(List<@NotNull String> apiGroups) {
        this.apiGroups = apiGroups;
    }

    public V1RuleWithOperations apiGroups(List<@NotNull String> apiGroups) {
        this.apiGroups = apiGroups;
        return this;
    }

    public V1RuleWithOperations addapiGroupsItem(String apiGroupsItem) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(apiGroupsItem);
        return this;
    }

    public List<@NotNull String> getApiVersions() {
        return this.apiVersions;
    }

    public void setApiVersions(List<@NotNull String> apiVersions) {
        this.apiVersions = apiVersions;
    }

    public V1RuleWithOperations apiVersions(List<@NotNull String> apiVersions) {
        this.apiVersions = apiVersions;
        return this;
    }

    public V1RuleWithOperations addapiVersionsItem(String apiVersionsItem) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        this.apiVersions.add(apiVersionsItem);
        return this;
    }

    public List<@NotNull String> getOperations() {
        return this.operations;
    }

    public void setOperations(List<@NotNull String> operations) {
        this.operations = operations;
    }

    public V1RuleWithOperations operations(List<@NotNull String> operations) {
        this.operations = operations;
        return this;
    }

    public V1RuleWithOperations addoperationsItem(String operationsItem) {
        if (this.operations == null) {
            this.operations = new ArrayList<String>();
        }
        this.operations.add(operationsItem);
        return this;
    }

    public List<@NotNull String> getResources() {
        return this.resources;
    }

    public void setResources(List<@NotNull String> resources) {
        this.resources = resources;
    }

    public V1RuleWithOperations resources(List<@NotNull String> resources) {
        this.resources = resources;
        return this;
    }

    public V1RuleWithOperations addresourcesItem(String resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public V1RuleWithOperations scope(String scope) {
        this.scope = scope;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1RuleWithOperations v1RuleWithOperations = (V1RuleWithOperations)o;
        return Objects.equals(this.apiGroups, v1RuleWithOperations.apiGroups) && Objects.equals(this.apiVersions, v1RuleWithOperations.apiVersions) && Objects.equals(this.operations, v1RuleWithOperations.operations) && Objects.equals(this.resources, v1RuleWithOperations.resources) && Objects.equals(this.scope, v1RuleWithOperations.scope);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroups, this.apiVersions, this.operations, this.resources, this.scope);
    }

    public String toString() {
        return "V1RuleWithOperations(apiGroups: " + this.getApiGroups() + ", apiVersions: " + this.getApiVersions() + ", operations: " + this.getOperations() + ", resources: " + this.getResources() + ", scope: " + this.getScope() + ")";
    }
}

