/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"apiVersion", "data", "immutable", "kind", "metadata", "stringData", "type"})
public class V1Secret {
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_DATA = "data";
    public static final String JSON_PROPERTY_IMMUTABLE = "immutable";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    public static final String JSON_PROPERTY_STRING_DATA = "stringData";
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @Pattern(regexp="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$") @NotNull byte[]> data;
    @Nullable
    @JsonProperty(value="immutable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean immutable;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;
    @Nullable
    @JsonProperty(value="stringData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> stringData;
    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String type;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1Secret apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public Map<String, @Pattern(regexp="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$") @NotNull byte[]> getData() {
        return this.data;
    }

    public void setData(Map<String, @Pattern(regexp="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$") @NotNull byte[]> data) {
        this.data = data;
    }

    public V1Secret data(Map<String, @Pattern(regexp="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$") @NotNull byte[]> data) {
        this.data = data;
        return this;
    }

    public V1Secret putdataItem(String key, byte[] dataItem) {
        if (this.data == null) {
            this.data = new HashMap<String, byte[]>();
        }
        this.data.put(key, dataItem);
        return this;
    }

    public Boolean getImmutable() {
        return this.immutable;
    }

    public void setImmutable(Boolean immutable) {
        this.immutable = immutable;
    }

    public V1Secret immutable(Boolean immutable) {
        this.immutable = immutable;
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1Secret kind(String kind) {
        this.kind = kind;
        return this;
    }

    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1Secret metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public Map<String, @NotNull String> getStringData() {
        return this.stringData;
    }

    public void setStringData(Map<String, @NotNull String> stringData) {
        this.stringData = stringData;
    }

    public V1Secret stringData(Map<String, @NotNull String> stringData) {
        this.stringData = stringData;
        return this;
    }

    public V1Secret putstringDataItem(String key, String stringDataItem) {
        if (this.stringData == null) {
            this.stringData = new HashMap<String, String>();
        }
        this.stringData.put(key, stringDataItem);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public V1Secret type(String type) {
        this.type = type;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Secret v1Secret = (V1Secret)o;
        return Objects.equals(this.apiVersion, v1Secret.apiVersion) && Objects.equals(this.data, v1Secret.data) && Objects.equals(this.immutable, v1Secret.immutable) && Objects.equals(this.kind, v1Secret.kind) && Objects.equals(this.metadata, v1Secret.metadata) && Objects.equals(this.stringData, v1Secret.stringData) && Objects.equals(this.type, v1Secret.type);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.data, this.immutable, this.kind, this.metadata, this.stringData, this.type);
    }

    public String toString() {
        return "V1Secret(apiVersion: " + this.getApiVersion() + ", data: " + this.getData() + ", immutable: " + this.getImmutable() + ", kind: " + this.getKind() + ", metadata: " + this.getMetadata() + ", stringData: " + this.getStringData() + ", type: " + this.getType() + ")";
    }
}

