/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1StatefulSetCondition;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"replicas", "availableReplicas", "collisionCount", "conditions", "currentReplicas", "currentRevision", "observedGeneration", "readyReplicas", "updateRevision", "updatedReplicas"})
public class V1StatefulSetStatus {
    public static final String JSON_PROPERTY_REPLICAS = "replicas";
    public static final String JSON_PROPERTY_AVAILABLE_REPLICAS = "availableReplicas";
    public static final String JSON_PROPERTY_COLLISION_COUNT = "collisionCount";
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    public static final String JSON_PROPERTY_CURRENT_REPLICAS = "currentReplicas";
    public static final String JSON_PROPERTY_CURRENT_REVISION = "currentRevision";
    public static final String JSON_PROPERTY_OBSERVED_GENERATION = "observedGeneration";
    public static final String JSON_PROPERTY_READY_REPLICAS = "readyReplicas";
    public static final String JSON_PROPERTY_UPDATE_REVISION = "updateRevision";
    public static final String JSON_PROPERTY_UPDATED_REPLICAS = "updatedReplicas";
    @NotNull
    @JsonProperty(value="replicas")
    private Integer replicas;
    @Nullable
    @JsonProperty(value="availableReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer availableReplicas;
    @Nullable
    @JsonProperty(value="collisionCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer collisionCount;
    @Nullable
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1StatefulSetCondition> conditions;
    @Nullable
    @JsonProperty(value="currentReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer currentReplicas;
    @Nullable
    @JsonProperty(value="currentRevision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String currentRevision;
    @Nullable
    @JsonProperty(value="observedGeneration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Long observedGeneration;
    @Nullable
    @JsonProperty(value="readyReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer readyReplicas;
    @Nullable
    @JsonProperty(value="updateRevision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String updateRevision;
    @Nullable
    @JsonProperty(value="updatedReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer updatedReplicas;

    public V1StatefulSetStatus(Integer replicas) {
        this.replicas = replicas;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1StatefulSetStatus replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public void setAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
    }

    public V1StatefulSetStatus availableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return this;
    }

    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public void setCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
    }

    public V1StatefulSetStatus collisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return this;
    }

    public List<@Valid V1StatefulSetCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<@Valid V1StatefulSetCondition> conditions) {
        this.conditions = conditions;
    }

    public V1StatefulSetStatus conditions(List<@Valid V1StatefulSetCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1StatefulSetStatus addconditionsItem(V1StatefulSetCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1StatefulSetCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public void setCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
    }

    public V1StatefulSetStatus currentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return this;
    }

    public String getCurrentRevision() {
        return this.currentRevision;
    }

    public void setCurrentRevision(String currentRevision) {
        this.currentRevision = currentRevision;
    }

    public V1StatefulSetStatus currentRevision(String currentRevision) {
        this.currentRevision = currentRevision;
        return this;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1StatefulSetStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public void setReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
    }

    public V1StatefulSetStatus readyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return this;
    }

    public String getUpdateRevision() {
        return this.updateRevision;
    }

    public void setUpdateRevision(String updateRevision) {
        this.updateRevision = updateRevision;
    }

    public V1StatefulSetStatus updateRevision(String updateRevision) {
        this.updateRevision = updateRevision;
        return this;
    }

    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    public void setUpdatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
    }

    public V1StatefulSetStatus updatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StatefulSetStatus v1StatefulSetStatus = (V1StatefulSetStatus)o;
        return Objects.equals(this.replicas, v1StatefulSetStatus.replicas) && Objects.equals(this.availableReplicas, v1StatefulSetStatus.availableReplicas) && Objects.equals(this.collisionCount, v1StatefulSetStatus.collisionCount) && Objects.equals(this.conditions, v1StatefulSetStatus.conditions) && Objects.equals(this.currentReplicas, v1StatefulSetStatus.currentReplicas) && Objects.equals(this.currentRevision, v1StatefulSetStatus.currentRevision) && Objects.equals(this.observedGeneration, v1StatefulSetStatus.observedGeneration) && Objects.equals(this.readyReplicas, v1StatefulSetStatus.readyReplicas) && Objects.equals(this.updateRevision, v1StatefulSetStatus.updateRevision) && Objects.equals(this.updatedReplicas, v1StatefulSetStatus.updatedReplicas);
    }

    public int hashCode() {
        return Objects.hash(this.replicas, this.availableReplicas, this.collisionCount, this.conditions, this.currentReplicas, this.currentRevision, this.observedGeneration, this.readyReplicas, this.updateRevision, this.updatedReplicas);
    }

    public String toString() {
        return "V1StatefulSetStatus(replicas: " + this.getReplicas() + ", availableReplicas: " + this.getAvailableReplicas() + ", collisionCount: " + this.getCollisionCount() + ", conditions: " + this.getConditions() + ", currentReplicas: " + this.getCurrentReplicas() + ", currentRevision: " + this.getCurrentRevision() + ", observedGeneration: " + this.getObservedGeneration() + ", readyReplicas: " + this.getReadyReplicas() + ", updateRevision: " + this.getUpdateRevision() + ", updatedReplicas: " + this.getUpdatedReplicas() + ")";
    }
}

