/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"kind", "name", "apiGroup", "namespace"})
public class V1Subject {
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_NAME = "name";
    public static final String JSON_PROPERTY_API_GROUP = "apiGroup";
    public static final String JSON_PROPERTY_NAMESPACE = "namespace";
    @NotNull
    @JsonProperty(value="kind")
    private String kind;
    @NotNull
    @JsonProperty(value="name")
    private String name;
    @Nullable
    @JsonProperty(value="apiGroup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiGroup;
    @Nullable
    @JsonProperty(value="namespace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String namespace;

    public V1Subject(String kind, String name) {
        this.kind = kind;
        this.name = name;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1Subject kind(String kind) {
        this.kind = kind;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1Subject name(String name) {
        this.name = name;
        return this;
    }

    public String getApiGroup() {
        return this.apiGroup;
    }

    public void setApiGroup(String apiGroup) {
        this.apiGroup = apiGroup;
    }

    public V1Subject apiGroup(String apiGroup) {
        this.apiGroup = apiGroup;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public V1Subject namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Subject v1Subject = (V1Subject)o;
        return Objects.equals(this.kind, v1Subject.kind) && Objects.equals(this.name, v1Subject.name) && Objects.equals(this.apiGroup, v1Subject.apiGroup) && Objects.equals(this.namespace, v1Subject.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.name, this.apiGroup, this.namespace);
    }

    public String toString() {
        return "V1Subject(kind: " + this.getKind() + ", name: " + this.getName() + ", apiGroup: " + this.getApiGroup() + ", namespace: " + this.getNamespace() + ")";
    }
}

