/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V2ContainerResourceMetricSource;
import io.micronaut.kubernetes.client.openapi.model.V2ExternalMetricSource;
import io.micronaut.kubernetes.client.openapi.model.V2ObjectMetricSource;
import io.micronaut.kubernetes.client.openapi.model.V2PodsMetricSource;
import io.micronaut.kubernetes.client.openapi.model.V2ResourceMetricSource;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"type", "containerResource", "external", "object", "pods", "resource"})
public class V2MetricSpec {
    public static final String JSON_PROPERTY_TYPE = "type";
    public static final String JSON_PROPERTY_CONTAINER_RESOURCE = "containerResource";
    public static final String JSON_PROPERTY_EXTERNAL = "external";
    public static final String JSON_PROPERTY_OBJECT = "object";
    public static final String JSON_PROPERTY_PODS = "pods";
    public static final String JSON_PROPERTY_RESOURCE = "resource";
    @NotNull
    @JsonProperty(value="type")
    private String type;
    @Nullable
    @Valid
    @JsonProperty(value="containerResource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V2ContainerResourceMetricSource containerResource;
    @Nullable
    @Valid
    @JsonProperty(value="external")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V2ExternalMetricSource external;
    @Nullable
    @Valid
    @JsonProperty(value="object")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V2ObjectMetricSource object;
    @Nullable
    @Valid
    @JsonProperty(value="pods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V2PodsMetricSource pods;
    @Nullable
    @Valid
    @JsonProperty(value="resource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V2ResourceMetricSource resource;

    public V2MetricSpec(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public V2MetricSpec type(String type) {
        this.type = type;
        return this;
    }

    public V2ContainerResourceMetricSource getContainerResource() {
        return this.containerResource;
    }

    public void setContainerResource(V2ContainerResourceMetricSource containerResource) {
        this.containerResource = containerResource;
    }

    public V2MetricSpec containerResource(V2ContainerResourceMetricSource containerResource) {
        this.containerResource = containerResource;
        return this;
    }

    public V2ExternalMetricSource getExternal() {
        return this.external;
    }

    public void setExternal(V2ExternalMetricSource external) {
        this.external = external;
    }

    public V2MetricSpec external(V2ExternalMetricSource external) {
        this.external = external;
        return this;
    }

    public V2ObjectMetricSource getObject() {
        return this.object;
    }

    public void setObject(V2ObjectMetricSource object) {
        this.object = object;
    }

    public V2MetricSpec object(V2ObjectMetricSource object) {
        this.object = object;
        return this;
    }

    public V2PodsMetricSource getPods() {
        return this.pods;
    }

    public void setPods(V2PodsMetricSource pods) {
        this.pods = pods;
    }

    public V2MetricSpec pods(V2PodsMetricSource pods) {
        this.pods = pods;
        return this;
    }

    public V2ResourceMetricSource getResource() {
        return this.resource;
    }

    public void setResource(V2ResourceMetricSource resource) {
        this.resource = resource;
    }

    public V2MetricSpec resource(V2ResourceMetricSource resource) {
        this.resource = resource;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2MetricSpec v2MetricSpec = (V2MetricSpec)o;
        return Objects.equals(this.type, v2MetricSpec.type) && Objects.equals(this.containerResource, v2MetricSpec.containerResource) && Objects.equals(this.external, v2MetricSpec.external) && Objects.equals(this.object, v2MetricSpec.object) && Objects.equals(this.pods, v2MetricSpec.pods) && Objects.equals(this.resource, v2MetricSpec.resource);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.containerResource, this.external, this.object, this.pods, this.resource);
    }

    public String toString() {
        return "V2MetricSpec(type: " + this.getType() + ", containerResource: " + this.getContainerResource() + ", external: " + this.getExternal() + ", object: " + this.getObject() + ", pods: " + this.getPods() + ", resource: " + this.getResource() + ")";
    }
}

