/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.ssl;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Internal;
import io.micronaut.kubernetes.client.openapi.ssl.KubernetesPrivateKeyLoader;
import io.micronaut.kubernetes.client.openapi.ssl.PKCS1Util;
import jakarta.inject.Singleton;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Base64;

@Singleton
@BootstrapContextCompatible
@Internal
public class DefaultPrivateKeyLoader
implements KubernetesPrivateKeyLoader {
    @Override
    public PrivateKey loadPrivateKey(byte[] clientKey) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        PemData pemData = this.parsePem(clientKey);
        if ("RSA".equals(pemData.keyAlgorithm)) {
            RSAPrivateCrtKeySpec keySpec = PKCS1Util.decodePKCS1(pemData.key);
            return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
        }
        if ("EC".equals(pemData.keyAlgorithm)) {
            return KeyFactory.getInstance("EC").generatePrivate(PKCS1Util.getECKeySpec(pemData.key));
        }
        try {
            return KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(pemData.key));
        }
        catch (InvalidKeySpecException ex) {
            return KeyFactory.getInstance("EC").generatePrivate(new PKCS8EncodedKeySpec(pemData.key));
        }
    }

    private PemData parsePem(byte[] clientKey) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(clientKey)));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("-----BEGIN ")) continue;
                String keyAlgorithm = "";
                if (line.contains("BEGIN EC PRIVATE KEY")) {
                    keyAlgorithm = "EC";
                } else if (line.contains("BEGIN RSA PRIVATE KEY")) {
                    keyAlgorithm = "RSA";
                }
                String endMarker = line.trim().replace("BEGIN", "END");
                byte[] key = this.readBytes(reader, endMarker);
                PemData pemData = new PemData(keyAlgorithm, key);
                return pemData;
            }
            throw new IOException("PEM is invalid: no begin marker");
        }
    }

    private byte[] readBytes(BufferedReader reader, String endMarker) throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (line.contains(endMarker)) {
                return Base64.getDecoder().decode(builder.toString());
            }
            builder.append(line.trim());
        }
        throw new IOException("PEM is invalid : No end marker");
    }

    private record PemData(String keyAlgorithm, byte[] key) {
    }
}

