/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ProviderUtils;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.kubernetes.client.openapi.config.KubeConfig;
import io.micronaut.kubernetes.client.openapi.config.KubeConfigLoader;
import io.micronaut.kubernetes.client.openapi.config.KubernetesClientConfiguration;
import io.micronaut.kubernetes.client.openapi.config.model.AuthInfo;
import io.micronaut.kubernetes.client.openapi.credential.KubernetesTokenLoader;
import io.micronaut.kubernetes.client.openapi.credential.ReactiveKubernetesTokenLoader;
import io.micronaut.kubernetes.client.openapi.credential.TokenLoader;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Requires(beans={KubernetesClientConfiguration.class})
@Internal
@BootstrapContextCompatible
@Filter(patterns={"/**"}, serviceId={"kubernetes"})
final class KubernetesHttpClientFilter
implements HttpClientFilter {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesHttpClientFilter.class);
    private final Provider<KubeConfig> kubeConfigProvider = ProviderUtils.memoized(() -> ((KubeConfigLoader)kubeConfigLoader.get()).getKubeConfig());
    private final Provider<Collection<TokenLoader>> tokenLoaders = ProviderUtils.memoized(() -> applicationContext.getBeansOfType(TokenLoader.class));
    private final Scheduler scheduler;

    KubernetesHttpClientFilter(Provider<KubeConfigLoader> kubeConfigLoader, ApplicationContext applicationContext, @Named(value="blocking") @Nullable ExecutorService executorService) {
        this.scheduler = executorService == null ? null : Schedulers.fromExecutorService((ExecutorService)executorService);
    }

    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> request, ClientFilterChain chain) {
        KubeConfig kubeConfig = (KubeConfig)this.kubeConfigProvider.get();
        if (kubeConfig != null && kubeConfig.getUser() != null) {
            AuthInfo user = kubeConfig.getUser();
            if (user.clientCertificateData() != null && user.clientKeyData() != null) {
                LOG.trace("Using client certificate authentication");
                return chain.proceed(request);
            }
            if (StringUtils.isNotEmpty((CharSequence)user.username()) && StringUtils.isNotEmpty((CharSequence)user.password())) {
                LOG.trace("Using username and password authentication");
                return chain.proceed(request.basicAuth((CharSequence)user.username(), (CharSequence)user.password()));
            }
        }
        Collection loaders = (Collection)this.tokenLoaders.get();
        LOG.trace("Using token authentication, tokenLoaders={}", (Object)loaders);
        return Flux.fromIterable((Iterable)loaders).concatMap(this::getToken).next().switchIfEmpty(Mono.just((Object)"")).doOnNext(token -> {
            if (StringUtils.isEmpty((CharSequence)token)) {
                LOG.trace("Token not loaded by any token loader");
            }
        }).flatMapMany(token -> StringUtils.isEmpty((CharSequence)token) ? chain.proceed(request) : chain.proceed(request.bearerAuth((CharSequence)token)));
    }

    private Publisher<String> getToken(TokenLoader tokenLoader) {
        if (tokenLoader instanceof ReactiveKubernetesTokenLoader) {
            ReactiveKubernetesTokenLoader reactiveTokenLoader = (ReactiveKubernetesTokenLoader)tokenLoader;
            return reactiveTokenLoader.getToken();
        }
        if (tokenLoader instanceof KubernetesTokenLoader) {
            KubernetesTokenLoader blockingTokenLoader = (KubernetesTokenLoader)tokenLoader;
            Mono publisher = Mono.fromCallable(blockingTokenLoader::getToken);
            if (this.scheduler != null) {
                publisher = publisher.subscribeOn(this.scheduler);
            }
            return publisher.doOnNext(token -> LOG.trace("Token loaded by {}", (Object)blockingTokenLoader.getClass().getName()));
        }
        LOG.error("Found unknown token loader implementation: {}", (Object)tokenLoader.getClass().getName());
        return Mono.empty();
    }
}

