/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.config;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.Toggleable;
import java.time.Duration;

@Internal
@BootstrapContextCompatible
@ConfigurationProperties(value="kubernetes.client")
@Requires(property="kubernetes.client.enabled", value="true", defaultValue="true")
public class KubernetesClientConfiguration
implements Toggleable {
    public static final String PREFIX = "kubernetes.client";
    private String kubeConfigPath;
    private boolean enabled = true;
    private String namespace;
    private ServiceAccount serviceAccount = new ServiceAccount();

    public String getKubeConfigPath() {
        return this.kubeConfigPath;
    }

    void setKubeConfigPath(String kubeConfigPath) {
        this.kubeConfigPath = kubeConfigPath;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public ServiceAccount getServiceAccount() {
        return this.serviceAccount;
    }

    public void setServiceAccount(ServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    @ConfigurationProperties(value="service-account")
    public static class ServiceAccount {
        private static final String SERVICE_ACCOUNT_DIR = "file:/var/run/secrets/kubernetes.io/serviceaccount/";
        private static final String CA_PATH = "file:/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
        private static final String TOKEN_PATH = "file:/var/run/secrets/kubernetes.io/serviceaccount/token";
        private static final String NAMESPACE_PATH = "file:/var/run/secrets/kubernetes.io/serviceaccount/namespace";
        private boolean enabled = true;
        private String certificateAuthorityPath = "file:/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
        private String tokenPath = "file:/var/run/secrets/kubernetes.io/serviceaccount/token";
        private String namespacePath = "file:/var/run/secrets/kubernetes.io/serviceaccount/namespace";
        private Duration tokenReloadInterval = Duration.ofSeconds(60L);

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getCertificateAuthorityPath() {
            return this.certificateAuthorityPath;
        }

        public void setCertificateAuthorityPath(String certificateAuthorityPath) {
            this.certificateAuthorityPath = certificateAuthorityPath;
        }

        public String getTokenPath() {
            return this.tokenPath;
        }

        public void setTokenPath(String tokenPath) {
            this.tokenPath = tokenPath;
        }

        public String getNamespacePath() {
            return this.namespacePath;
        }

        public void setNamespacePath(String namespacePath) {
            this.namespacePath = namespacePath;
        }

        public Duration getTokenReloadInterval() {
            return this.tokenReloadInterval;
        }

        public void setTokenReloadInterval(Duration tokenReloadInterval) {
            this.tokenReloadInterval = tokenReloadInterval;
        }
    }
}

