/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.credential;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.kubernetes.client.openapi.config.KubernetesClientConfiguration;
import io.micronaut.kubernetes.client.openapi.credential.ReactiveKubernetesTokenLoader;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Internal
@Singleton
@BootstrapContextCompatible
@Requirements(value={@Requires(env={"k8s"}), @Requires(property="kubernetes.client.service-account.enabled", value="true", defaultValue="true")})
final class ServiceAccountTokenLoader
implements ReactiveKubernetesTokenLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceAccountTokenLoader.class);
    private static final int ORDER = 30;
    private final ResourceResolver resourceResolver;
    private final KubernetesClientConfiguration.ServiceAccount serviceAccount;
    private final Scheduler scheduler;
    private volatile String token;
    private volatile LocalDateTime expirationTime;

    ServiceAccountTokenLoader(ResourceResolver resourceResolver, KubernetesClientConfiguration kubernetesClientConfiguration, @Named(value="blocking") @Nullable ExecutorService executorService) {
        this.resourceResolver = resourceResolver;
        this.serviceAccount = kubernetesClientConfiguration.getServiceAccount();
        this.scheduler = executorService == null ? null : Schedulers.fromExecutorService((ExecutorService)executorService);
    }

    public int getOrder() {
        return 30;
    }

    @Override
    public Publisher<String> getToken() {
        if (!this.shouldLoadToken()) {
            return Mono.just((Object)this.token).doOnNext(it -> LOG.trace("Token loaded"));
        }
        Mono publisher = Mono.fromCallable(this::reloadedToken);
        if (this.scheduler != null) {
            publisher = publisher.subscribeOn(this.scheduler);
        }
        return publisher.doOnNext(it -> LOG.trace("Token loaded"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String reloadedToken() {
        if (this.shouldLoadToken()) {
            ServiceAccountTokenLoader serviceAccountTokenLoader = this;
            synchronized (serviceAccountTokenLoader) {
                if (this.shouldLoadToken()) {
                    String tokenPath = this.serviceAccount.getTokenPath();
                    Duration tokenReloadInterval = this.serviceAccount.getTokenReloadInterval();
                    try {
                        this.token = this.loadToken(tokenPath);
                        this.expirationTime = LocalDateTime.now().plusSeconds(tokenReloadInterval.toSeconds());
                    }
                    catch (Exception e) {
                        LOG.error("Failed to load token from file: {}", (Object)tokenPath, (Object)e);
                    }
                }
            }
        }
        return this.token;
    }

    private boolean shouldLoadToken() {
        if (this.token == null || this.expirationTime == null) {
            return true;
        }
        LocalDateTime now = LocalDateTime.now();
        LOG.debug("Check whether token reloading needed, now={}, expiration={}", (Object)now, (Object)this.expirationTime);
        return this.expirationTime.isBefore(now);
    }

    private String loadToken(String tokenPath) throws IOException {
        LOG.debug("Loading token from file: {}", (Object)tokenPath);
        Optional inputStreamOpt = this.resourceResolver.getResourceAsStream(tokenPath);
        if (inputStreamOpt.isEmpty()) {
            throw new ConfigurationException("Token file not found: " + tokenPath);
        }
        InputStream inputStream = (InputStream)inputStreamOpt.get();
        return new String(inputStream.readAllBytes());
    }
}

