/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1GroupVersionForDiscovery;
import io.micronaut.kubernetes.client.openapi.model.V1ServerAddressByClientCIDR;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"name", "versions", "apiVersion", "kind", "preferredVersion", "serverAddressByClientCIDRs"})
public class V1APIGroup {
    public static final String JSON_PROPERTY_NAME = "name";
    public static final String JSON_PROPERTY_VERSIONS = "versions";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_PREFERRED_VERSION = "preferredVersion";
    public static final String JSON_PROPERTY_SERVER_ADDRESS_BY_CLIENT_C_I_D_RS = "serverAddressByClientCIDRs";
    @NotNull
    @JsonProperty(value="name")
    private String name;
    @NotNull
    @JsonProperty(value="versions")
    private @NotNull List<@Valid V1GroupVersionForDiscovery> versions;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="preferredVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1GroupVersionForDiscovery preferredVersion;
    @Nullable
    @JsonProperty(value="serverAddressByClientCIDRs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1ServerAddressByClientCIDR> serverAddressByClientCIDRs;

    public V1APIGroup(String name, List<@Valid V1GroupVersionForDiscovery> versions) {
        this.name = name;
        this.versions = versions;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1APIGroup name(String name) {
        this.name = name;
        return this;
    }

    public List<@Valid V1GroupVersionForDiscovery> getVersions() {
        return this.versions;
    }

    public void setVersions(List<@Valid V1GroupVersionForDiscovery> versions) {
        this.versions = versions;
    }

    public V1APIGroup versions(List<@Valid V1GroupVersionForDiscovery> versions) {
        this.versions = versions;
        return this;
    }

    public V1APIGroup addVersionsItem(V1GroupVersionForDiscovery versionsItem) {
        this.versions.add(versionsItem);
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1APIGroup apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1APIGroup kind(String kind) {
        this.kind = kind;
        return this;
    }

    public V1GroupVersionForDiscovery getPreferredVersion() {
        return this.preferredVersion;
    }

    public void setPreferredVersion(V1GroupVersionForDiscovery preferredVersion) {
        this.preferredVersion = preferredVersion;
    }

    public V1APIGroup preferredVersion(V1GroupVersionForDiscovery preferredVersion) {
        this.preferredVersion = preferredVersion;
        return this;
    }

    public List<@Valid V1ServerAddressByClientCIDR> getServerAddressByClientCIDRs() {
        return this.serverAddressByClientCIDRs;
    }

    public void setServerAddressByClientCIDRs(List<@Valid V1ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
        this.serverAddressByClientCIDRs = serverAddressByClientCIDRs;
    }

    public V1APIGroup serverAddressByClientCIDRs(List<@Valid V1ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
        this.serverAddressByClientCIDRs = serverAddressByClientCIDRs;
        return this;
    }

    public V1APIGroup addServerAddressByClientCIDRsItem(V1ServerAddressByClientCIDR serverAddressByClientCIDRsItem) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList<V1ServerAddressByClientCIDR>();
        }
        this.serverAddressByClientCIDRs.add(serverAddressByClientCIDRsItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIGroup v1APIGroup = (V1APIGroup)o;
        return Objects.equals(this.name, v1APIGroup.name) && Objects.equals(this.versions, v1APIGroup.versions) && Objects.equals(this.apiVersion, v1APIGroup.apiVersion) && Objects.equals(this.kind, v1APIGroup.kind) && Objects.equals(this.preferredVersion, v1APIGroup.preferredVersion) && Objects.equals(this.serverAddressByClientCIDRs, v1APIGroup.serverAddressByClientCIDRs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.versions, this.apiVersion, this.kind, this.preferredVersion, this.serverAddressByClientCIDRs);
    }

    public String toString() {
        return "V1APIGroup(name: " + this.getName() + ", versions: " + this.getVersions() + ", apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ", preferredVersion: " + this.getPreferredVersion() + ", serverAddressByClientCIDRs: " + this.getServerAddressByClientCIDRs() + ")";
    }
}

