/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1ServerAddressByClientCIDR;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"serverAddressByClientCIDRs", "versions", "apiVersion", "kind"})
public class V1APIVersions {
    public static final String JSON_PROPERTY_SERVER_ADDRESS_BY_CLIENT_C_I_D_RS = "serverAddressByClientCIDRs";
    public static final String JSON_PROPERTY_VERSIONS = "versions";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    @NotNull
    @JsonProperty(value="serverAddressByClientCIDRs")
    private @NotNull List<@Valid V1ServerAddressByClientCIDR> serverAddressByClientCIDRs;
    @NotNull
    @JsonProperty(value="versions")
    private @NotNull List<@NotNull String> versions;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;

    public V1APIVersions(List<@Valid V1ServerAddressByClientCIDR> serverAddressByClientCIDRs, List<@NotNull String> versions) {
        this.serverAddressByClientCIDRs = serverAddressByClientCIDRs;
        this.versions = versions;
    }

    public List<@Valid V1ServerAddressByClientCIDR> getServerAddressByClientCIDRs() {
        return this.serverAddressByClientCIDRs;
    }

    public void setServerAddressByClientCIDRs(List<@Valid V1ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
        this.serverAddressByClientCIDRs = serverAddressByClientCIDRs;
    }

    public V1APIVersions serverAddressByClientCIDRs(List<@Valid V1ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
        this.serverAddressByClientCIDRs = serverAddressByClientCIDRs;
        return this;
    }

    public V1APIVersions addServerAddressByClientCIDRsItem(V1ServerAddressByClientCIDR serverAddressByClientCIDRsItem) {
        this.serverAddressByClientCIDRs.add(serverAddressByClientCIDRsItem);
        return this;
    }

    public List<@NotNull String> getVersions() {
        return this.versions;
    }

    public void setVersions(List<@NotNull String> versions) {
        this.versions = versions;
    }

    public V1APIVersions versions(List<@NotNull String> versions) {
        this.versions = versions;
        return this;
    }

    public V1APIVersions addVersionsItem(String versionsItem) {
        this.versions.add(versionsItem);
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1APIVersions apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1APIVersions kind(String kind) {
        this.kind = kind;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIVersions v1APIVersions = (V1APIVersions)o;
        return Objects.equals(this.serverAddressByClientCIDRs, v1APIVersions.serverAddressByClientCIDRs) && Objects.equals(this.versions, v1APIVersions.versions) && Objects.equals(this.apiVersion, v1APIVersions.apiVersion) && Objects.equals(this.kind, v1APIVersions.kind);
    }

    public int hashCode() {
        return Objects.hash(this.serverAddressByClientCIDRs, this.versions, this.apiVersion, this.kind);
    }

    public String toString() {
        return "V1APIVersions(serverAddressByClientCIDRs: " + this.getServerAddressByClientCIDRs() + ", versions: " + this.getVersions() + ", apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ")";
    }
}

