/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.common.KubernetesObject;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectReference;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"target", "apiVersion", "kind", "metadata"})
public class V1Binding
implements KubernetesObject {
    public static final String JSON_PROPERTY_TARGET = "target";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    @NotNull
    @Valid
    @JsonProperty(value="target")
    private V1ObjectReference target;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;

    public V1Binding(V1ObjectReference target) {
        this.target = target;
    }

    public V1ObjectReference getTarget() {
        return this.target;
    }

    public void setTarget(V1ObjectReference target) {
        this.target = target;
    }

    public V1Binding target(V1ObjectReference target) {
        this.target = target;
        return this;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1Binding apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1Binding kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1Binding metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Binding v1Binding = (V1Binding)o;
        return Objects.equals(this.target, v1Binding.target) && Objects.equals(this.apiVersion, v1Binding.apiVersion) && Objects.equals(this.kind, v1Binding.kind) && Objects.equals(this.metadata, v1Binding.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.apiVersion, this.kind, this.metadata);
    }

    public String toString() {
        return "V1Binding(target: " + this.getTarget() + ", apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ", metadata: " + this.getMetadata() + ")";
    }
}

