/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.common.KubernetesObject;
import io.micronaut.kubernetes.client.openapi.model.V1CSINodeSpec;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"spec", "apiVersion", "kind", "metadata"})
public class V1CSINode
implements KubernetesObject {
    public static final String JSON_PROPERTY_SPEC = "spec";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    @NotNull
    @Valid
    @JsonProperty(value="spec")
    private V1CSINodeSpec spec;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;

    public V1CSINode(V1CSINodeSpec spec) {
        this.spec = spec;
    }

    public V1CSINodeSpec getSpec() {
        return this.spec;
    }

    public void setSpec(V1CSINodeSpec spec) {
        this.spec = spec;
    }

    public V1CSINode spec(V1CSINodeSpec spec) {
        this.spec = spec;
        return this;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1CSINode apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1CSINode kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1CSINode metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CSINode v1CSINode = (V1CSINode)o;
        return Objects.equals(this.spec, v1CSINode.spec) && Objects.equals(this.apiVersion, v1CSINode.apiVersion) && Objects.equals(this.kind, v1CSINode.kind) && Objects.equals(this.metadata, v1CSINode.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.spec, this.apiVersion, this.kind, this.metadata);
    }

    public String toString() {
        return "V1CSINode(spec: " + this.getSpec() + ", apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ", metadata: " + this.getMetadata() + ")";
    }
}

