/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1SecretReference;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"driver", "volumeHandle", "controllerExpandSecretRef", "controllerPublishSecretRef", "fsType", "nodeExpandSecretRef", "nodePublishSecretRef", "nodeStageSecretRef", "readOnly", "volumeAttributes"})
public class V1CSIPersistentVolumeSource {
    public static final String JSON_PROPERTY_DRIVER = "driver";
    public static final String JSON_PROPERTY_VOLUME_HANDLE = "volumeHandle";
    public static final String JSON_PROPERTY_CONTROLLER_EXPAND_SECRET_REF = "controllerExpandSecretRef";
    public static final String JSON_PROPERTY_CONTROLLER_PUBLISH_SECRET_REF = "controllerPublishSecretRef";
    public static final String JSON_PROPERTY_FS_TYPE = "fsType";
    public static final String JSON_PROPERTY_NODE_EXPAND_SECRET_REF = "nodeExpandSecretRef";
    public static final String JSON_PROPERTY_NODE_PUBLISH_SECRET_REF = "nodePublishSecretRef";
    public static final String JSON_PROPERTY_NODE_STAGE_SECRET_REF = "nodeStageSecretRef";
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    public static final String JSON_PROPERTY_VOLUME_ATTRIBUTES = "volumeAttributes";
    @NotNull
    @JsonProperty(value="driver")
    private String driver;
    @NotNull
    @JsonProperty(value="volumeHandle")
    private String volumeHandle;
    @Nullable
    @Valid
    @JsonProperty(value="controllerExpandSecretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1SecretReference controllerExpandSecretRef;
    @Nullable
    @Valid
    @JsonProperty(value="controllerPublishSecretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1SecretReference controllerPublishSecretRef;
    @Nullable
    @JsonProperty(value="fsType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String fsType;
    @Nullable
    @Valid
    @JsonProperty(value="nodeExpandSecretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1SecretReference nodeExpandSecretRef;
    @Nullable
    @Valid
    @JsonProperty(value="nodePublishSecretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1SecretReference nodePublishSecretRef;
    @Nullable
    @Valid
    @JsonProperty(value="nodeStageSecretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1SecretReference nodeStageSecretRef;
    @Nullable
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean readOnly;
    @Nullable
    @JsonProperty(value="volumeAttributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> volumeAttributes;

    public V1CSIPersistentVolumeSource(String driver, String volumeHandle) {
        this.driver = driver;
        this.volumeHandle = volumeHandle;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public V1CSIPersistentVolumeSource driver(String driver) {
        this.driver = driver;
        return this;
    }

    public String getVolumeHandle() {
        return this.volumeHandle;
    }

    public void setVolumeHandle(String volumeHandle) {
        this.volumeHandle = volumeHandle;
    }

    public V1CSIPersistentVolumeSource volumeHandle(String volumeHandle) {
        this.volumeHandle = volumeHandle;
        return this;
    }

    public V1SecretReference getControllerExpandSecretRef() {
        return this.controllerExpandSecretRef;
    }

    public void setControllerExpandSecretRef(V1SecretReference controllerExpandSecretRef) {
        this.controllerExpandSecretRef = controllerExpandSecretRef;
    }

    public V1CSIPersistentVolumeSource controllerExpandSecretRef(V1SecretReference controllerExpandSecretRef) {
        this.controllerExpandSecretRef = controllerExpandSecretRef;
        return this;
    }

    public V1SecretReference getControllerPublishSecretRef() {
        return this.controllerPublishSecretRef;
    }

    public void setControllerPublishSecretRef(V1SecretReference controllerPublishSecretRef) {
        this.controllerPublishSecretRef = controllerPublishSecretRef;
    }

    public V1CSIPersistentVolumeSource controllerPublishSecretRef(V1SecretReference controllerPublishSecretRef) {
        this.controllerPublishSecretRef = controllerPublishSecretRef;
        return this;
    }

    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1CSIPersistentVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    public V1SecretReference getNodeExpandSecretRef() {
        return this.nodeExpandSecretRef;
    }

    public void setNodeExpandSecretRef(V1SecretReference nodeExpandSecretRef) {
        this.nodeExpandSecretRef = nodeExpandSecretRef;
    }

    public V1CSIPersistentVolumeSource nodeExpandSecretRef(V1SecretReference nodeExpandSecretRef) {
        this.nodeExpandSecretRef = nodeExpandSecretRef;
        return this;
    }

    public V1SecretReference getNodePublishSecretRef() {
        return this.nodePublishSecretRef;
    }

    public void setNodePublishSecretRef(V1SecretReference nodePublishSecretRef) {
        this.nodePublishSecretRef = nodePublishSecretRef;
    }

    public V1CSIPersistentVolumeSource nodePublishSecretRef(V1SecretReference nodePublishSecretRef) {
        this.nodePublishSecretRef = nodePublishSecretRef;
        return this;
    }

    public V1SecretReference getNodeStageSecretRef() {
        return this.nodeStageSecretRef;
    }

    public void setNodeStageSecretRef(V1SecretReference nodeStageSecretRef) {
        this.nodeStageSecretRef = nodeStageSecretRef;
    }

    public V1CSIPersistentVolumeSource nodeStageSecretRef(V1SecretReference nodeStageSecretRef) {
        this.nodeStageSecretRef = nodeStageSecretRef;
        return this;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1CSIPersistentVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public Map<String, @NotNull String> getVolumeAttributes() {
        return this.volumeAttributes;
    }

    public void setVolumeAttributes(Map<String, @NotNull String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes;
    }

    public V1CSIPersistentVolumeSource volumeAttributes(Map<String, @NotNull String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes;
        return this;
    }

    public V1CSIPersistentVolumeSource putVolumeAttributesItem(String key, String volumeAttributesItem) {
        if (this.volumeAttributes == null) {
            this.volumeAttributes = new HashMap<String, String>();
        }
        this.volumeAttributes.put(key, volumeAttributesItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CSIPersistentVolumeSource v1CSIPersistentVolumeSource = (V1CSIPersistentVolumeSource)o;
        return Objects.equals(this.driver, v1CSIPersistentVolumeSource.driver) && Objects.equals(this.volumeHandle, v1CSIPersistentVolumeSource.volumeHandle) && Objects.equals(this.controllerExpandSecretRef, v1CSIPersistentVolumeSource.controllerExpandSecretRef) && Objects.equals(this.controllerPublishSecretRef, v1CSIPersistentVolumeSource.controllerPublishSecretRef) && Objects.equals(this.fsType, v1CSIPersistentVolumeSource.fsType) && Objects.equals(this.nodeExpandSecretRef, v1CSIPersistentVolumeSource.nodeExpandSecretRef) && Objects.equals(this.nodePublishSecretRef, v1CSIPersistentVolumeSource.nodePublishSecretRef) && Objects.equals(this.nodeStageSecretRef, v1CSIPersistentVolumeSource.nodeStageSecretRef) && Objects.equals(this.readOnly, v1CSIPersistentVolumeSource.readOnly) && Objects.equals(this.volumeAttributes, v1CSIPersistentVolumeSource.volumeAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.driver, this.volumeHandle, this.controllerExpandSecretRef, this.controllerPublishSecretRef, this.fsType, this.nodeExpandSecretRef, this.nodePublishSecretRef, this.nodeStageSecretRef, this.readOnly, this.volumeAttributes);
    }

    public String toString() {
        return "V1CSIPersistentVolumeSource(driver: " + this.getDriver() + ", volumeHandle: " + this.getVolumeHandle() + ", controllerExpandSecretRef: " + this.getControllerExpandSecretRef() + ", controllerPublishSecretRef: " + this.getControllerPublishSecretRef() + ", fsType: " + this.getFsType() + ", nodeExpandSecretRef: " + this.getNodeExpandSecretRef() + ", nodePublishSecretRef: " + this.getNodePublishSecretRef() + ", nodeStageSecretRef: " + this.getNodeStageSecretRef() + ", readOnly: " + this.getReadOnly() + ", volumeAttributes: " + this.getVolumeAttributes() + ")";
    }
}

