/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.common.KubernetesObject;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"apiVersion", "binaryData", "data", "immutable", "kind", "metadata"})
public class V1ConfigMap
implements KubernetesObject {
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_BINARY_DATA = "binaryData";
    public static final String JSON_PROPERTY_DATA = "data";
    public static final String JSON_PROPERTY_IMMUTABLE = "immutable";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="binaryData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @Pattern(regexp="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$") byte @Nullable []> binaryData;
    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> data;
    @Nullable
    @JsonProperty(value="immutable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean immutable;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1ConfigMap apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public Map<String, @Pattern(regexp="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$") byte @Nullable []> getBinaryData() {
        return this.binaryData;
    }

    public void setBinaryData(Map<String, @Pattern(regexp="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$") byte @Nullable []> binaryData) {
        this.binaryData = binaryData;
    }

    public V1ConfigMap binaryData(Map<String, @Pattern(regexp="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$") byte @Nullable []> binaryData) {
        this.binaryData = binaryData;
        return this;
    }

    public V1ConfigMap putBinaryDataItem(String key, byte[] binaryDataItem) {
        if (this.binaryData == null) {
            this.binaryData = new HashMap<String, byte[]>();
        }
        this.binaryData.put(key, binaryDataItem);
        return this;
    }

    public Map<String, @NotNull String> getData() {
        return this.data;
    }

    public void setData(Map<String, @NotNull String> data) {
        this.data = data;
    }

    public V1ConfigMap data(Map<String, @NotNull String> data) {
        this.data = data;
        return this;
    }

    public V1ConfigMap putDataItem(String key, String dataItem) {
        if (this.data == null) {
            this.data = new HashMap<String, String>();
        }
        this.data.put(key, dataItem);
        return this;
    }

    public Boolean getImmutable() {
        return this.immutable;
    }

    public void setImmutable(Boolean immutable) {
        this.immutable = immutable;
    }

    public V1ConfigMap immutable(Boolean immutable) {
        this.immutable = immutable;
        return this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1ConfigMap kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1ConfigMap metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ConfigMap v1ConfigMap = (V1ConfigMap)o;
        return Objects.equals(this.apiVersion, v1ConfigMap.apiVersion) && Objects.equals(this.binaryData, v1ConfigMap.binaryData) && Objects.equals(this.data, v1ConfigMap.data) && Objects.equals(this.immutable, v1ConfigMap.immutable) && Objects.equals(this.kind, v1ConfigMap.kind) && Objects.equals(this.metadata, v1ConfigMap.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.binaryData, this.data, this.immutable, this.kind, this.metadata);
    }

    public String toString() {
        return "V1ConfigMap(apiVersion: " + this.getApiVersion() + ", binaryData: " + this.getBinaryData() + ", data: " + this.getData() + ", immutable: " + this.getImmutable() + ", kind: " + this.getKind() + ", metadata: " + this.getMetadata() + ")";
    }
}

