/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1HTTPHeader;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"port", "host", "httpHeaders", "path", "scheme"})
public class V1HTTPGetAction {
    public static final String JSON_PROPERTY_PORT = "port";
    public static final String JSON_PROPERTY_HOST = "host";
    public static final String JSON_PROPERTY_HTTP_HEADERS = "httpHeaders";
    public static final String JSON_PROPERTY_PATH = "path";
    public static final String JSON_PROPERTY_SCHEME = "scheme";
    @NotNull
    @JsonProperty(value="port")
    private String port;
    @Nullable
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String host;
    @Nullable
    @JsonProperty(value="httpHeaders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1HTTPHeader> httpHeaders;
    @Nullable
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String path;
    @Nullable
    @JsonProperty(value="scheme")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String scheme;

    public V1HTTPGetAction(String port) {
        this.port = port;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public V1HTTPGetAction port(String port) {
        this.port = port;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public V1HTTPGetAction host(String host) {
        this.host = host;
        return this;
    }

    public List<@Valid V1HTTPHeader> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(List<@Valid V1HTTPHeader> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public V1HTTPGetAction httpHeaders(List<@Valid V1HTTPHeader> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public V1HTTPGetAction addHttpHeadersItem(V1HTTPHeader httpHeadersItem) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList<V1HTTPHeader>();
        }
        this.httpHeaders.add(httpHeadersItem);
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public V1HTTPGetAction path(String path) {
        this.path = path;
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public V1HTTPGetAction scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1HTTPGetAction v1HTTPGetAction = (V1HTTPGetAction)o;
        return Objects.equals(this.port, v1HTTPGetAction.port) && Objects.equals(this.host, v1HTTPGetAction.host) && Objects.equals(this.httpHeaders, v1HTTPGetAction.httpHeaders) && Objects.equals(this.path, v1HTTPGetAction.path) && Objects.equals(this.scheme, v1HTTPGetAction.scheme);
    }

    public int hashCode() {
        return Objects.hash(this.port, this.host, this.httpHeaders, this.path, this.scheme);
    }

    public String toString() {
        return "V1HTTPGetAction(port: " + this.getPort() + ", host: " + this.getHost() + ", httpHeaders: " + this.getHttpHeaders() + ", path: " + this.getPath() + ", scheme: " + this.getScheme() + ")";
    }
}

