/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.common.KubernetesObject;
import io.micronaut.kubernetes.client.openapi.model.V1MutatingWebhook;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "webhooks"})
public class V1MutatingWebhookConfiguration
implements KubernetesObject {
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    public static final String JSON_PROPERTY_WEBHOOKS = "webhooks";
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;
    @Nullable
    @JsonProperty(value="webhooks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1MutatingWebhook> webhooks;

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1MutatingWebhookConfiguration apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1MutatingWebhookConfiguration kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1MutatingWebhookConfiguration metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<@Valid V1MutatingWebhook> getWebhooks() {
        return this.webhooks;
    }

    public void setWebhooks(List<@Valid V1MutatingWebhook> webhooks) {
        this.webhooks = webhooks;
    }

    public V1MutatingWebhookConfiguration webhooks(List<@Valid V1MutatingWebhook> webhooks) {
        this.webhooks = webhooks;
        return this;
    }

    public V1MutatingWebhookConfiguration addWebhooksItem(V1MutatingWebhook webhooksItem) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList<V1MutatingWebhook>();
        }
        this.webhooks.add(webhooksItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1MutatingWebhookConfiguration v1MutatingWebhookConfiguration = (V1MutatingWebhookConfiguration)o;
        return Objects.equals(this.apiVersion, v1MutatingWebhookConfiguration.apiVersion) && Objects.equals(this.kind, v1MutatingWebhookConfiguration.kind) && Objects.equals(this.metadata, v1MutatingWebhookConfiguration.metadata) && Objects.equals(this.webhooks, v1MutatingWebhookConfiguration.webhooks);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.webhooks);
    }

    public String toString() {
        return "V1MutatingWebhookConfiguration(apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ", metadata: " + this.getMetadata() + ", webhooks: " + this.getWebhooks() + ")";
    }
}

