/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1AttachedVolume;
import io.micronaut.kubernetes.client.openapi.model.V1ContainerImage;
import io.micronaut.kubernetes.client.openapi.model.V1NodeAddress;
import io.micronaut.kubernetes.client.openapi.model.V1NodeCondition;
import io.micronaut.kubernetes.client.openapi.model.V1NodeConfigStatus;
import io.micronaut.kubernetes.client.openapi.model.V1NodeDaemonEndpoints;
import io.micronaut.kubernetes.client.openapi.model.V1NodeFeatures;
import io.micronaut.kubernetes.client.openapi.model.V1NodeRuntimeHandler;
import io.micronaut.kubernetes.client.openapi.model.V1NodeSystemInfo;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"addresses", "allocatable", "capacity", "conditions", "config", "daemonEndpoints", "features", "images", "nodeInfo", "phase", "runtimeHandlers", "volumesAttached", "volumesInUse"})
public class V1NodeStatus {
    public static final String JSON_PROPERTY_ADDRESSES = "addresses";
    public static final String JSON_PROPERTY_ALLOCATABLE = "allocatable";
    public static final String JSON_PROPERTY_CAPACITY = "capacity";
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    public static final String JSON_PROPERTY_CONFIG = "config";
    public static final String JSON_PROPERTY_DAEMON_ENDPOINTS = "daemonEndpoints";
    public static final String JSON_PROPERTY_FEATURES = "features";
    public static final String JSON_PROPERTY_IMAGES = "images";
    public static final String JSON_PROPERTY_NODE_INFO = "nodeInfo";
    public static final String JSON_PROPERTY_PHASE = "phase";
    public static final String JSON_PROPERTY_RUNTIME_HANDLERS = "runtimeHandlers";
    public static final String JSON_PROPERTY_VOLUMES_ATTACHED = "volumesAttached";
    public static final String JSON_PROPERTY_VOLUMES_IN_USE = "volumesInUse";
    @Nullable
    @JsonProperty(value="addresses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1NodeAddress> addresses;
    @Nullable
    @JsonProperty(value="allocatable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> allocatable;
    @Nullable
    @JsonProperty(value="capacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> capacity;
    @Nullable
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1NodeCondition> conditions;
    @Nullable
    @Valid
    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1NodeConfigStatus config;
    @Nullable
    @Valid
    @JsonProperty(value="daemonEndpoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1NodeDaemonEndpoints daemonEndpoints;
    @Nullable
    @Valid
    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1NodeFeatures features;
    @Nullable
    @JsonProperty(value="images")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1ContainerImage> images;
    @Nullable
    @Valid
    @JsonProperty(value="nodeInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1NodeSystemInfo nodeInfo;
    @Nullable
    @JsonProperty(value="phase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String phase;
    @Nullable
    @JsonProperty(value="runtimeHandlers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1NodeRuntimeHandler> runtimeHandlers;
    @Nullable
    @JsonProperty(value="volumesAttached")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1AttachedVolume> volumesAttached;
    @Nullable
    @JsonProperty(value="volumesInUse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> volumesInUse;

    public List<@Valid V1NodeAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<@Valid V1NodeAddress> addresses) {
        this.addresses = addresses;
    }

    public V1NodeStatus addresses(List<@Valid V1NodeAddress> addresses) {
        this.addresses = addresses;
        return this;
    }

    public V1NodeStatus addAddressesItem(V1NodeAddress addressesItem) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<V1NodeAddress>();
        }
        this.addresses.add(addressesItem);
        return this;
    }

    public Map<String, @NotNull String> getAllocatable() {
        return this.allocatable;
    }

    public void setAllocatable(Map<String, @NotNull String> allocatable) {
        this.allocatable = allocatable;
    }

    public V1NodeStatus allocatable(Map<String, @NotNull String> allocatable) {
        this.allocatable = allocatable;
        return this;
    }

    public V1NodeStatus putAllocatableItem(String key, String allocatableItem) {
        if (this.allocatable == null) {
            this.allocatable = new HashMap<String, String>();
        }
        this.allocatable.put(key, allocatableItem);
        return this;
    }

    public Map<String, @NotNull String> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Map<String, @NotNull String> capacity) {
        this.capacity = capacity;
    }

    public V1NodeStatus capacity(Map<String, @NotNull String> capacity) {
        this.capacity = capacity;
        return this;
    }

    public V1NodeStatus putCapacityItem(String key, String capacityItem) {
        if (this.capacity == null) {
            this.capacity = new HashMap<String, String>();
        }
        this.capacity.put(key, capacityItem);
        return this;
    }

    public List<@Valid V1NodeCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<@Valid V1NodeCondition> conditions) {
        this.conditions = conditions;
    }

    public V1NodeStatus conditions(List<@Valid V1NodeCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1NodeStatus addConditionsItem(V1NodeCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1NodeCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    public V1NodeConfigStatus getConfig() {
        return this.config;
    }

    public void setConfig(V1NodeConfigStatus config) {
        this.config = config;
    }

    public V1NodeStatus config(V1NodeConfigStatus config) {
        this.config = config;
        return this;
    }

    public V1NodeDaemonEndpoints getDaemonEndpoints() {
        return this.daemonEndpoints;
    }

    public void setDaemonEndpoints(V1NodeDaemonEndpoints daemonEndpoints) {
        this.daemonEndpoints = daemonEndpoints;
    }

    public V1NodeStatus daemonEndpoints(V1NodeDaemonEndpoints daemonEndpoints) {
        this.daemonEndpoints = daemonEndpoints;
        return this;
    }

    public V1NodeFeatures getFeatures() {
        return this.features;
    }

    public void setFeatures(V1NodeFeatures features) {
        this.features = features;
    }

    public V1NodeStatus features(V1NodeFeatures features) {
        this.features = features;
        return this;
    }

    public List<@Valid V1ContainerImage> getImages() {
        return this.images;
    }

    public void setImages(List<@Valid V1ContainerImage> images) {
        this.images = images;
    }

    public V1NodeStatus images(List<@Valid V1ContainerImage> images) {
        this.images = images;
        return this;
    }

    public V1NodeStatus addImagesItem(V1ContainerImage imagesItem) {
        if (this.images == null) {
            this.images = new ArrayList<V1ContainerImage>();
        }
        this.images.add(imagesItem);
        return this;
    }

    public V1NodeSystemInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public void setNodeInfo(V1NodeSystemInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public V1NodeStatus nodeInfo(V1NodeSystemInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
        return this;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public V1NodeStatus phase(String phase) {
        this.phase = phase;
        return this;
    }

    public List<@Valid V1NodeRuntimeHandler> getRuntimeHandlers() {
        return this.runtimeHandlers;
    }

    public void setRuntimeHandlers(List<@Valid V1NodeRuntimeHandler> runtimeHandlers) {
        this.runtimeHandlers = runtimeHandlers;
    }

    public V1NodeStatus runtimeHandlers(List<@Valid V1NodeRuntimeHandler> runtimeHandlers) {
        this.runtimeHandlers = runtimeHandlers;
        return this;
    }

    public V1NodeStatus addRuntimeHandlersItem(V1NodeRuntimeHandler runtimeHandlersItem) {
        if (this.runtimeHandlers == null) {
            this.runtimeHandlers = new ArrayList<V1NodeRuntimeHandler>();
        }
        this.runtimeHandlers.add(runtimeHandlersItem);
        return this;
    }

    public List<@Valid V1AttachedVolume> getVolumesAttached() {
        return this.volumesAttached;
    }

    public void setVolumesAttached(List<@Valid V1AttachedVolume> volumesAttached) {
        this.volumesAttached = volumesAttached;
    }

    public V1NodeStatus volumesAttached(List<@Valid V1AttachedVolume> volumesAttached) {
        this.volumesAttached = volumesAttached;
        return this;
    }

    public V1NodeStatus addVolumesAttachedItem(V1AttachedVolume volumesAttachedItem) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList<V1AttachedVolume>();
        }
        this.volumesAttached.add(volumesAttachedItem);
        return this;
    }

    public List<@NotNull String> getVolumesInUse() {
        return this.volumesInUse;
    }

    public void setVolumesInUse(List<@NotNull String> volumesInUse) {
        this.volumesInUse = volumesInUse;
    }

    public V1NodeStatus volumesInUse(List<@NotNull String> volumesInUse) {
        this.volumesInUse = volumesInUse;
        return this;
    }

    public V1NodeStatus addVolumesInUseItem(String volumesInUseItem) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        this.volumesInUse.add(volumesInUseItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NodeStatus v1NodeStatus = (V1NodeStatus)o;
        return Objects.equals(this.addresses, v1NodeStatus.addresses) && Objects.equals(this.allocatable, v1NodeStatus.allocatable) && Objects.equals(this.capacity, v1NodeStatus.capacity) && Objects.equals(this.conditions, v1NodeStatus.conditions) && Objects.equals(this.config, v1NodeStatus.config) && Objects.equals(this.daemonEndpoints, v1NodeStatus.daemonEndpoints) && Objects.equals(this.features, v1NodeStatus.features) && Objects.equals(this.images, v1NodeStatus.images) && Objects.equals(this.nodeInfo, v1NodeStatus.nodeInfo) && Objects.equals(this.phase, v1NodeStatus.phase) && Objects.equals(this.runtimeHandlers, v1NodeStatus.runtimeHandlers) && Objects.equals(this.volumesAttached, v1NodeStatus.volumesAttached) && Objects.equals(this.volumesInUse, v1NodeStatus.volumesInUse);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.allocatable, this.capacity, this.conditions, this.config, this.daemonEndpoints, this.features, this.images, this.nodeInfo, this.phase, this.runtimeHandlers, this.volumesAttached, this.volumesInUse);
    }

    public String toString() {
        return "V1NodeStatus(addresses: " + this.getAddresses() + ", allocatable: " + this.getAllocatable() + ", capacity: " + this.getCapacity() + ", conditions: " + this.getConditions() + ", config: " + this.getConfig() + ", daemonEndpoints: " + this.getDaemonEndpoints() + ", features: " + this.getFeatures() + ", images: " + this.getImages() + ", nodeInfo: " + this.getNodeInfo() + ", phase: " + this.getPhase() + ", runtimeHandlers: " + this.getRuntimeHandlers() + ", volumesAttached: " + this.getVolumesAttached() + ", volumesInUse: " + this.getVolumesInUse() + ")";
    }
}

