/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1ModifyVolumeStatus;
import io.micronaut.kubernetes.client.openapi.model.V1PersistentVolumeClaimCondition;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"accessModes", "allocatedResourceStatuses", "allocatedResources", "capacity", "conditions", "currentVolumeAttributesClassName", "modifyVolumeStatus", "phase"})
public class V1PersistentVolumeClaimStatus {
    public static final String JSON_PROPERTY_ACCESS_MODES = "accessModes";
    public static final String JSON_PROPERTY_ALLOCATED_RESOURCE_STATUSES = "allocatedResourceStatuses";
    public static final String JSON_PROPERTY_ALLOCATED_RESOURCES = "allocatedResources";
    public static final String JSON_PROPERTY_CAPACITY = "capacity";
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    public static final String JSON_PROPERTY_CURRENT_VOLUME_ATTRIBUTES_CLASS_NAME = "currentVolumeAttributesClassName";
    public static final String JSON_PROPERTY_MODIFY_VOLUME_STATUS = "modifyVolumeStatus";
    public static final String JSON_PROPERTY_PHASE = "phase";
    @Nullable
    @JsonProperty(value="accessModes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> accessModes;
    @Nullable
    @JsonProperty(value="allocatedResourceStatuses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> allocatedResourceStatuses;
    @Nullable
    @JsonProperty(value="allocatedResources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> allocatedResources;
    @Nullable
    @JsonProperty(value="capacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> capacity;
    @Nullable
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1PersistentVolumeClaimCondition> conditions;
    @Nullable
    @JsonProperty(value="currentVolumeAttributesClassName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String currentVolumeAttributesClassName;
    @Nullable
    @Valid
    @JsonProperty(value="modifyVolumeStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ModifyVolumeStatus modifyVolumeStatus;
    @Nullable
    @JsonProperty(value="phase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String phase;

    public List<@NotNull String> getAccessModes() {
        return this.accessModes;
    }

    public void setAccessModes(List<@NotNull String> accessModes) {
        this.accessModes = accessModes;
    }

    public V1PersistentVolumeClaimStatus accessModes(List<@NotNull String> accessModes) {
        this.accessModes = accessModes;
        return this;
    }

    public V1PersistentVolumeClaimStatus addAccessModesItem(String accessModesItem) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(accessModesItem);
        return this;
    }

    public Map<String, @NotNull String> getAllocatedResourceStatuses() {
        return this.allocatedResourceStatuses;
    }

    public void setAllocatedResourceStatuses(Map<String, @NotNull String> allocatedResourceStatuses) {
        this.allocatedResourceStatuses = allocatedResourceStatuses;
    }

    public V1PersistentVolumeClaimStatus allocatedResourceStatuses(Map<String, @NotNull String> allocatedResourceStatuses) {
        this.allocatedResourceStatuses = allocatedResourceStatuses;
        return this;
    }

    public V1PersistentVolumeClaimStatus putAllocatedResourceStatusesItem(String key, String allocatedResourceStatusesItem) {
        if (this.allocatedResourceStatuses == null) {
            this.allocatedResourceStatuses = new HashMap<String, String>();
        }
        this.allocatedResourceStatuses.put(key, allocatedResourceStatusesItem);
        return this;
    }

    public Map<String, @NotNull String> getAllocatedResources() {
        return this.allocatedResources;
    }

    public void setAllocatedResources(Map<String, @NotNull String> allocatedResources) {
        this.allocatedResources = allocatedResources;
    }

    public V1PersistentVolumeClaimStatus allocatedResources(Map<String, @NotNull String> allocatedResources) {
        this.allocatedResources = allocatedResources;
        return this;
    }

    public V1PersistentVolumeClaimStatus putAllocatedResourcesItem(String key, String allocatedResourcesItem) {
        if (this.allocatedResources == null) {
            this.allocatedResources = new HashMap<String, String>();
        }
        this.allocatedResources.put(key, allocatedResourcesItem);
        return this;
    }

    public Map<String, @NotNull String> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Map<String, @NotNull String> capacity) {
        this.capacity = capacity;
    }

    public V1PersistentVolumeClaimStatus capacity(Map<String, @NotNull String> capacity) {
        this.capacity = capacity;
        return this;
    }

    public V1PersistentVolumeClaimStatus putCapacityItem(String key, String capacityItem) {
        if (this.capacity == null) {
            this.capacity = new HashMap<String, String>();
        }
        this.capacity.put(key, capacityItem);
        return this;
    }

    public List<@Valid V1PersistentVolumeClaimCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<@Valid V1PersistentVolumeClaimCondition> conditions) {
        this.conditions = conditions;
    }

    public V1PersistentVolumeClaimStatus conditions(List<@Valid V1PersistentVolumeClaimCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1PersistentVolumeClaimStatus addConditionsItem(V1PersistentVolumeClaimCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1PersistentVolumeClaimCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    public String getCurrentVolumeAttributesClassName() {
        return this.currentVolumeAttributesClassName;
    }

    public void setCurrentVolumeAttributesClassName(String currentVolumeAttributesClassName) {
        this.currentVolumeAttributesClassName = currentVolumeAttributesClassName;
    }

    public V1PersistentVolumeClaimStatus currentVolumeAttributesClassName(String currentVolumeAttributesClassName) {
        this.currentVolumeAttributesClassName = currentVolumeAttributesClassName;
        return this;
    }

    public V1ModifyVolumeStatus getModifyVolumeStatus() {
        return this.modifyVolumeStatus;
    }

    public void setModifyVolumeStatus(V1ModifyVolumeStatus modifyVolumeStatus) {
        this.modifyVolumeStatus = modifyVolumeStatus;
    }

    public V1PersistentVolumeClaimStatus modifyVolumeStatus(V1ModifyVolumeStatus modifyVolumeStatus) {
        this.modifyVolumeStatus = modifyVolumeStatus;
        return this;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public V1PersistentVolumeClaimStatus phase(String phase) {
        this.phase = phase;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PersistentVolumeClaimStatus v1PersistentVolumeClaimStatus = (V1PersistentVolumeClaimStatus)o;
        return Objects.equals(this.accessModes, v1PersistentVolumeClaimStatus.accessModes) && Objects.equals(this.allocatedResourceStatuses, v1PersistentVolumeClaimStatus.allocatedResourceStatuses) && Objects.equals(this.allocatedResources, v1PersistentVolumeClaimStatus.allocatedResources) && Objects.equals(this.capacity, v1PersistentVolumeClaimStatus.capacity) && Objects.equals(this.conditions, v1PersistentVolumeClaimStatus.conditions) && Objects.equals(this.currentVolumeAttributesClassName, v1PersistentVolumeClaimStatus.currentVolumeAttributesClassName) && Objects.equals(this.modifyVolumeStatus, v1PersistentVolumeClaimStatus.modifyVolumeStatus) && Objects.equals(this.phase, v1PersistentVolumeClaimStatus.phase);
    }

    public int hashCode() {
        return Objects.hash(this.accessModes, this.allocatedResourceStatuses, this.allocatedResources, this.capacity, this.conditions, this.currentVolumeAttributesClassName, this.modifyVolumeStatus, this.phase);
    }

    public String toString() {
        return "V1PersistentVolumeClaimStatus(accessModes: " + this.getAccessModes() + ", allocatedResourceStatuses: " + this.getAllocatedResourceStatuses() + ", allocatedResources: " + this.getAllocatedResources() + ", capacity: " + this.getCapacity() + ", conditions: " + this.getConditions() + ", currentVolumeAttributesClassName: " + this.getCurrentVolumeAttributesClassName() + ", modifyVolumeStatus: " + this.getModifyVolumeStatus() + ", phase: " + this.getPhase() + ")";
    }
}

