/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1Condition;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"currentHealthy", "desiredHealthy", "disruptionsAllowed", "expectedPods", "conditions", "disruptedPods", "observedGeneration"})
public class V1PodDisruptionBudgetStatus {
    public static final String JSON_PROPERTY_CURRENT_HEALTHY = "currentHealthy";
    public static final String JSON_PROPERTY_DESIRED_HEALTHY = "desiredHealthy";
    public static final String JSON_PROPERTY_DISRUPTIONS_ALLOWED = "disruptionsAllowed";
    public static final String JSON_PROPERTY_EXPECTED_PODS = "expectedPods";
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    public static final String JSON_PROPERTY_DISRUPTED_PODS = "disruptedPods";
    public static final String JSON_PROPERTY_OBSERVED_GENERATION = "observedGeneration";
    @NotNull
    @JsonProperty(value="currentHealthy")
    private Integer currentHealthy;
    @NotNull
    @JsonProperty(value="desiredHealthy")
    private Integer desiredHealthy;
    @NotNull
    @JsonProperty(value="disruptionsAllowed")
    private Integer disruptionsAllowed;
    @NotNull
    @JsonProperty(value="expectedPods")
    private Integer expectedPods;
    @Nullable
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1Condition> conditions;
    @Nullable
    @JsonProperty(value="disruptedPods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull OffsetDateTime> disruptedPods;
    @Nullable
    @JsonProperty(value="observedGeneration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Long observedGeneration;

    public V1PodDisruptionBudgetStatus(Integer currentHealthy, Integer desiredHealthy, Integer disruptionsAllowed, Integer expectedPods) {
        this.currentHealthy = currentHealthy;
        this.desiredHealthy = desiredHealthy;
        this.disruptionsAllowed = disruptionsAllowed;
        this.expectedPods = expectedPods;
    }

    public Integer getCurrentHealthy() {
        return this.currentHealthy;
    }

    public void setCurrentHealthy(Integer currentHealthy) {
        this.currentHealthy = currentHealthy;
    }

    public V1PodDisruptionBudgetStatus currentHealthy(Integer currentHealthy) {
        this.currentHealthy = currentHealthy;
        return this;
    }

    public Integer getDesiredHealthy() {
        return this.desiredHealthy;
    }

    public void setDesiredHealthy(Integer desiredHealthy) {
        this.desiredHealthy = desiredHealthy;
    }

    public V1PodDisruptionBudgetStatus desiredHealthy(Integer desiredHealthy) {
        this.desiredHealthy = desiredHealthy;
        return this;
    }

    public Integer getDisruptionsAllowed() {
        return this.disruptionsAllowed;
    }

    public void setDisruptionsAllowed(Integer disruptionsAllowed) {
        this.disruptionsAllowed = disruptionsAllowed;
    }

    public V1PodDisruptionBudgetStatus disruptionsAllowed(Integer disruptionsAllowed) {
        this.disruptionsAllowed = disruptionsAllowed;
        return this;
    }

    public Integer getExpectedPods() {
        return this.expectedPods;
    }

    public void setExpectedPods(Integer expectedPods) {
        this.expectedPods = expectedPods;
    }

    public V1PodDisruptionBudgetStatus expectedPods(Integer expectedPods) {
        this.expectedPods = expectedPods;
        return this;
    }

    public List<@Valid V1Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<@Valid V1Condition> conditions) {
        this.conditions = conditions;
    }

    public V1PodDisruptionBudgetStatus conditions(List<@Valid V1Condition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1PodDisruptionBudgetStatus addConditionsItem(V1Condition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1Condition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    public Map<String, @NotNull OffsetDateTime> getDisruptedPods() {
        return this.disruptedPods;
    }

    public void setDisruptedPods(Map<String, @NotNull OffsetDateTime> disruptedPods) {
        this.disruptedPods = disruptedPods;
    }

    public V1PodDisruptionBudgetStatus disruptedPods(Map<String, @NotNull OffsetDateTime> disruptedPods) {
        this.disruptedPods = disruptedPods;
        return this;
    }

    public V1PodDisruptionBudgetStatus putDisruptedPodsItem(String key, OffsetDateTime disruptedPodsItem) {
        if (this.disruptedPods == null) {
            this.disruptedPods = new HashMap<String, OffsetDateTime>();
        }
        this.disruptedPods.put(key, disruptedPodsItem);
        return this;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1PodDisruptionBudgetStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodDisruptionBudgetStatus v1PodDisruptionBudgetStatus = (V1PodDisruptionBudgetStatus)o;
        return Objects.equals(this.currentHealthy, v1PodDisruptionBudgetStatus.currentHealthy) && Objects.equals(this.desiredHealthy, v1PodDisruptionBudgetStatus.desiredHealthy) && Objects.equals(this.disruptionsAllowed, v1PodDisruptionBudgetStatus.disruptionsAllowed) && Objects.equals(this.expectedPods, v1PodDisruptionBudgetStatus.expectedPods) && Objects.equals(this.conditions, v1PodDisruptionBudgetStatus.conditions) && Objects.equals(this.disruptedPods, v1PodDisruptionBudgetStatus.disruptedPods) && Objects.equals(this.observedGeneration, v1PodDisruptionBudgetStatus.observedGeneration);
    }

    public int hashCode() {
        return Objects.hash(this.currentHealthy, this.desiredHealthy, this.disruptionsAllowed, this.expectedPods, this.conditions, this.disruptedPods, this.observedGeneration);
    }

    public String toString() {
        return "V1PodDisruptionBudgetStatus(currentHealthy: " + this.getCurrentHealthy() + ", desiredHealthy: " + this.getDesiredHealthy() + ", disruptionsAllowed: " + this.getDisruptionsAllowed() + ", expectedPods: " + this.getExpectedPods() + ", conditions: " + this.getConditions() + ", disruptedPods: " + this.getDisruptedPods() + ", observedGeneration: " + this.getObservedGeneration() + ")";
    }
}

