/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"verbs", "apiGroups", "nonResourceURLs", "resourceNames", "resources"})
public class V1PolicyRule {
    public static final String JSON_PROPERTY_VERBS = "verbs";
    public static final String JSON_PROPERTY_API_GROUPS = "apiGroups";
    public static final String JSON_PROPERTY_NON_RESOURCE_U_R_LS = "nonResourceURLs";
    public static final String JSON_PROPERTY_RESOURCE_NAMES = "resourceNames";
    public static final String JSON_PROPERTY_RESOURCES = "resources";
    @NotNull
    @JsonProperty(value="verbs")
    private @NotNull List<@NotNull String> verbs;
    @Nullable
    @JsonProperty(value="apiGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> apiGroups;
    @Nullable
    @JsonProperty(value="nonResourceURLs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> nonResourceURLs;
    @Nullable
    @JsonProperty(value="resourceNames")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> resourceNames;
    @Nullable
    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> resources;

    public V1PolicyRule(List<@NotNull String> verbs) {
        this.verbs = verbs;
    }

    public List<@NotNull String> getVerbs() {
        return this.verbs;
    }

    public void setVerbs(List<@NotNull String> verbs) {
        this.verbs = verbs;
    }

    public V1PolicyRule verbs(List<@NotNull String> verbs) {
        this.verbs = verbs;
        return this;
    }

    public V1PolicyRule addVerbsItem(String verbsItem) {
        this.verbs.add(verbsItem);
        return this;
    }

    public List<@NotNull String> getApiGroups() {
        return this.apiGroups;
    }

    public void setApiGroups(List<@NotNull String> apiGroups) {
        this.apiGroups = apiGroups;
    }

    public V1PolicyRule apiGroups(List<@NotNull String> apiGroups) {
        this.apiGroups = apiGroups;
        return this;
    }

    public V1PolicyRule addApiGroupsItem(String apiGroupsItem) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(apiGroupsItem);
        return this;
    }

    public List<@NotNull String> getNonResourceURLs() {
        return this.nonResourceURLs;
    }

    public void setNonResourceURLs(List<@NotNull String> nonResourceURLs) {
        this.nonResourceURLs = nonResourceURLs;
    }

    public V1PolicyRule nonResourceURLs(List<@NotNull String> nonResourceURLs) {
        this.nonResourceURLs = nonResourceURLs;
        return this;
    }

    public V1PolicyRule addNonResourceURLsItem(String nonResourceURLsItem) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.add(nonResourceURLsItem);
        return this;
    }

    public List<@NotNull String> getResourceNames() {
        return this.resourceNames;
    }

    public void setResourceNames(List<@NotNull String> resourceNames) {
        this.resourceNames = resourceNames;
    }

    public V1PolicyRule resourceNames(List<@NotNull String> resourceNames) {
        this.resourceNames = resourceNames;
        return this;
    }

    public V1PolicyRule addResourceNamesItem(String resourceNamesItem) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        this.resourceNames.add(resourceNamesItem);
        return this;
    }

    public List<@NotNull String> getResources() {
        return this.resources;
    }

    public void setResources(List<@NotNull String> resources) {
        this.resources = resources;
    }

    public V1PolicyRule resources(List<@NotNull String> resources) {
        this.resources = resources;
        return this;
    }

    public V1PolicyRule addResourcesItem(String resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PolicyRule v1PolicyRule = (V1PolicyRule)o;
        return Objects.equals(this.verbs, v1PolicyRule.verbs) && Objects.equals(this.apiGroups, v1PolicyRule.apiGroups) && Objects.equals(this.nonResourceURLs, v1PolicyRule.nonResourceURLs) && Objects.equals(this.resourceNames, v1PolicyRule.resourceNames) && Objects.equals(this.resources, v1PolicyRule.resources);
    }

    public int hashCode() {
        return Objects.hash(this.verbs, this.apiGroups, this.nonResourceURLs, this.resourceNames, this.resources);
    }

    public String toString() {
        return "V1PolicyRule(verbs: " + this.getVerbs() + ", apiGroups: " + this.getApiGroups() + ", nonResourceURLs: " + this.getNonResourceURLs() + ", resourceNames: " + this.getResourceNames() + ", resources: " + this.getResources() + ")";
    }
}

