/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1LocalObjectReference;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"image", "monitors", "fsType", "keyring", "pool", "readOnly", "secretRef", "user"})
public class V1RBDVolumeSource {
    public static final String JSON_PROPERTY_IMAGE = "image";
    public static final String JSON_PROPERTY_MONITORS = "monitors";
    public static final String JSON_PROPERTY_FS_TYPE = "fsType";
    public static final String JSON_PROPERTY_KEYRING = "keyring";
    public static final String JSON_PROPERTY_POOL = "pool";
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    public static final String JSON_PROPERTY_SECRET_REF = "secretRef";
    public static final String JSON_PROPERTY_USER = "user";
    @NotNull
    @JsonProperty(value="image")
    private String image;
    @NotNull
    @JsonProperty(value="monitors")
    private @NotNull List<@NotNull String> monitors;
    @Nullable
    @JsonProperty(value="fsType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String fsType;
    @Nullable
    @JsonProperty(value="keyring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String keyring;
    @Nullable
    @JsonProperty(value="pool")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String pool;
    @Nullable
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean readOnly;
    @Nullable
    @Valid
    @JsonProperty(value="secretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1LocalObjectReference secretRef;
    @Nullable
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String user;

    public V1RBDVolumeSource(String image, List<@NotNull String> monitors) {
        this.image = image;
        this.monitors = monitors;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public V1RBDVolumeSource image(String image) {
        this.image = image;
        return this;
    }

    public List<@NotNull String> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(List<@NotNull String> monitors) {
        this.monitors = monitors;
    }

    public V1RBDVolumeSource monitors(List<@NotNull String> monitors) {
        this.monitors = monitors;
        return this;
    }

    public V1RBDVolumeSource addMonitorsItem(String monitorsItem) {
        this.monitors.add(monitorsItem);
        return this;
    }

    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1RBDVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    public String getKeyring() {
        return this.keyring;
    }

    public void setKeyring(String keyring) {
        this.keyring = keyring;
    }

    public V1RBDVolumeSource keyring(String keyring) {
        this.keyring = keyring;
        return this;
    }

    public String getPool() {
        return this.pool;
    }

    public void setPool(String pool) {
        this.pool = pool;
    }

    public V1RBDVolumeSource pool(String pool) {
        this.pool = pool;
        return this;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1RBDVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public V1LocalObjectReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(V1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
    }

    public V1RBDVolumeSource secretRef(V1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public V1RBDVolumeSource user(String user) {
        this.user = user;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1RBDVolumeSource v1RBDVolumeSource = (V1RBDVolumeSource)o;
        return Objects.equals(this.image, v1RBDVolumeSource.image) && Objects.equals(this.monitors, v1RBDVolumeSource.monitors) && Objects.equals(this.fsType, v1RBDVolumeSource.fsType) && Objects.equals(this.keyring, v1RBDVolumeSource.keyring) && Objects.equals(this.pool, v1RBDVolumeSource.pool) && Objects.equals(this.readOnly, v1RBDVolumeSource.readOnly) && Objects.equals(this.secretRef, v1RBDVolumeSource.secretRef) && Objects.equals(this.user, v1RBDVolumeSource.user);
    }

    public int hashCode() {
        return Objects.hash(this.image, this.monitors, this.fsType, this.keyring, this.pool, this.readOnly, this.secretRef, this.user);
    }

    public String toString() {
        return "V1RBDVolumeSource(image: " + this.getImage() + ", monitors: " + this.getMonitors() + ", fsType: " + this.getFsType() + ", keyring: " + this.getKeyring() + ", pool: " + this.getPool() + ", readOnly: " + this.getReadOnly() + ", secretRef: " + this.getSecretRef() + ", user: " + this.getUser() + ")";
    }
}

