/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1LabelSelector;
import io.micronaut.kubernetes.client.openapi.model.V1PodTemplateSpec;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"selector", "minReadySeconds", "replicas", "template"})
public class V1ReplicaSetSpec {
    public static final String JSON_PROPERTY_SELECTOR = "selector";
    public static final String JSON_PROPERTY_MIN_READY_SECONDS = "minReadySeconds";
    public static final String JSON_PROPERTY_REPLICAS = "replicas";
    public static final String JSON_PROPERTY_TEMPLATE = "template";
    @NotNull
    @Valid
    @JsonProperty(value="selector")
    private V1LabelSelector selector;
    @Nullable
    @JsonProperty(value="minReadySeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer minReadySeconds;
    @Nullable
    @JsonProperty(value="replicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer replicas;
    @Nullable
    @Valid
    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1PodTemplateSpec template;

    public V1ReplicaSetSpec(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1ReplicaSetSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public void setMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
    }

    public V1ReplicaSetSpec minReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return this;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1ReplicaSetSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public V1ReplicaSetSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ReplicaSetSpec v1ReplicaSetSpec = (V1ReplicaSetSpec)o;
        return Objects.equals(this.selector, v1ReplicaSetSpec.selector) && Objects.equals(this.minReadySeconds, v1ReplicaSetSpec.minReadySeconds) && Objects.equals(this.replicas, v1ReplicaSetSpec.replicas) && Objects.equals(this.template, v1ReplicaSetSpec.template);
    }

    public int hashCode() {
        return Objects.hash(this.selector, this.minReadySeconds, this.replicas, this.template);
    }

    public String toString() {
        return "V1ReplicaSetSpec(selector: " + this.getSelector() + ", minReadySeconds: " + this.getMinReadySeconds() + ", replicas: " + this.getReplicas() + ", template: " + this.getTemplate() + ")";
    }
}

