/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1PodTemplateSpec;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"minReadySeconds", "replicas", "selector", "template"})
public class V1ReplicationControllerSpec {
    public static final String JSON_PROPERTY_MIN_READY_SECONDS = "minReadySeconds";
    public static final String JSON_PROPERTY_REPLICAS = "replicas";
    public static final String JSON_PROPERTY_SELECTOR = "selector";
    public static final String JSON_PROPERTY_TEMPLATE = "template";
    @Nullable
    @JsonProperty(value="minReadySeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer minReadySeconds;
    @Nullable
    @JsonProperty(value="replicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer replicas;
    @Nullable
    @JsonProperty(value="selector")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> selector;
    @Nullable
    @Valid
    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1PodTemplateSpec template;

    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public void setMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
    }

    public V1ReplicationControllerSpec minReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return this;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1ReplicationControllerSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    public Map<String, @NotNull String> getSelector() {
        return this.selector;
    }

    public void setSelector(Map<String, @NotNull String> selector) {
        this.selector = selector;
    }

    public V1ReplicationControllerSpec selector(Map<String, @NotNull String> selector) {
        this.selector = selector;
        return this;
    }

    public V1ReplicationControllerSpec putSelectorItem(String key, String selectorItem) {
        if (this.selector == null) {
            this.selector = new HashMap<String, String>();
        }
        this.selector.put(key, selectorItem);
        return this;
    }

    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public V1ReplicationControllerSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ReplicationControllerSpec v1ReplicationControllerSpec = (V1ReplicationControllerSpec)o;
        return Objects.equals(this.minReadySeconds, v1ReplicationControllerSpec.minReadySeconds) && Objects.equals(this.replicas, v1ReplicationControllerSpec.replicas) && Objects.equals(this.selector, v1ReplicationControllerSpec.selector) && Objects.equals(this.template, v1ReplicationControllerSpec.template);
    }

    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.replicas, this.selector, this.template);
    }

    public String toString() {
        return "V1ReplicationControllerSpec(minReadySeconds: " + this.getMinReadySeconds() + ", replicas: " + this.getReplicas() + ", selector: " + this.getSelector() + ", template: " + this.getTemplate() + ")";
    }
}

