/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1ReplicationControllerCondition;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"replicas", "availableReplicas", "conditions", "fullyLabeledReplicas", "observedGeneration", "readyReplicas"})
public class V1ReplicationControllerStatus {
    public static final String JSON_PROPERTY_REPLICAS = "replicas";
    public static final String JSON_PROPERTY_AVAILABLE_REPLICAS = "availableReplicas";
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    public static final String JSON_PROPERTY_FULLY_LABELED_REPLICAS = "fullyLabeledReplicas";
    public static final String JSON_PROPERTY_OBSERVED_GENERATION = "observedGeneration";
    public static final String JSON_PROPERTY_READY_REPLICAS = "readyReplicas";
    @NotNull
    @JsonProperty(value="replicas")
    private Integer replicas;
    @Nullable
    @JsonProperty(value="availableReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer availableReplicas;
    @Nullable
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1ReplicationControllerCondition> conditions;
    @Nullable
    @JsonProperty(value="fullyLabeledReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer fullyLabeledReplicas;
    @Nullable
    @JsonProperty(value="observedGeneration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Long observedGeneration;
    @Nullable
    @JsonProperty(value="readyReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer readyReplicas;

    public V1ReplicationControllerStatus(Integer replicas) {
        this.replicas = replicas;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1ReplicationControllerStatus replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public void setAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
    }

    public V1ReplicationControllerStatus availableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return this;
    }

    public List<@Valid V1ReplicationControllerCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<@Valid V1ReplicationControllerCondition> conditions) {
        this.conditions = conditions;
    }

    public V1ReplicationControllerStatus conditions(List<@Valid V1ReplicationControllerCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1ReplicationControllerStatus addConditionsItem(V1ReplicationControllerCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1ReplicationControllerCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    public Integer getFullyLabeledReplicas() {
        return this.fullyLabeledReplicas;
    }

    public void setFullyLabeledReplicas(Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
    }

    public V1ReplicationControllerStatus fullyLabeledReplicas(Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
        return this;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1ReplicationControllerStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public void setReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
    }

    public V1ReplicationControllerStatus readyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ReplicationControllerStatus v1ReplicationControllerStatus = (V1ReplicationControllerStatus)o;
        return Objects.equals(this.replicas, v1ReplicationControllerStatus.replicas) && Objects.equals(this.availableReplicas, v1ReplicationControllerStatus.availableReplicas) && Objects.equals(this.conditions, v1ReplicationControllerStatus.conditions) && Objects.equals(this.fullyLabeledReplicas, v1ReplicationControllerStatus.fullyLabeledReplicas) && Objects.equals(this.observedGeneration, v1ReplicationControllerStatus.observedGeneration) && Objects.equals(this.readyReplicas, v1ReplicationControllerStatus.readyReplicas);
    }

    public int hashCode() {
        return Objects.hash(this.replicas, this.availableReplicas, this.conditions, this.fullyLabeledReplicas, this.observedGeneration, this.readyReplicas);
    }

    public String toString() {
        return "V1ReplicationControllerStatus(replicas: " + this.getReplicas() + ", availableReplicas: " + this.getAvailableReplicas() + ", conditions: " + this.getConditions() + ", fullyLabeledReplicas: " + this.getFullyLabeledReplicas() + ", observedGeneration: " + this.getObservedGeneration() + ", readyReplicas: " + this.getReadyReplicas() + ")";
    }
}

