/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"apiGroups", "resources", "verbs", "clusterScope", "namespaces"})
public class V1ResourcePolicyRule {
    public static final String JSON_PROPERTY_API_GROUPS = "apiGroups";
    public static final String JSON_PROPERTY_RESOURCES = "resources";
    public static final String JSON_PROPERTY_VERBS = "verbs";
    public static final String JSON_PROPERTY_CLUSTER_SCOPE = "clusterScope";
    public static final String JSON_PROPERTY_NAMESPACES = "namespaces";
    @NotNull
    @JsonProperty(value="apiGroups")
    private @NotNull List<@NotNull String> apiGroups;
    @NotNull
    @JsonProperty(value="resources")
    private @NotNull List<@NotNull String> resources;
    @NotNull
    @JsonProperty(value="verbs")
    private @NotNull List<@NotNull String> verbs;
    @Nullable
    @JsonProperty(value="clusterScope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean clusterScope;
    @Nullable
    @JsonProperty(value="namespaces")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> namespaces;

    public V1ResourcePolicyRule(List<@NotNull String> apiGroups, List<@NotNull String> resources, List<@NotNull String> verbs) {
        this.apiGroups = apiGroups;
        this.resources = resources;
        this.verbs = verbs;
    }

    public List<@NotNull String> getApiGroups() {
        return this.apiGroups;
    }

    public void setApiGroups(List<@NotNull String> apiGroups) {
        this.apiGroups = apiGroups;
    }

    public V1ResourcePolicyRule apiGroups(List<@NotNull String> apiGroups) {
        this.apiGroups = apiGroups;
        return this;
    }

    public V1ResourcePolicyRule addApiGroupsItem(String apiGroupsItem) {
        this.apiGroups.add(apiGroupsItem);
        return this;
    }

    public List<@NotNull String> getResources() {
        return this.resources;
    }

    public void setResources(List<@NotNull String> resources) {
        this.resources = resources;
    }

    public V1ResourcePolicyRule resources(List<@NotNull String> resources) {
        this.resources = resources;
        return this;
    }

    public V1ResourcePolicyRule addResourcesItem(String resourcesItem) {
        this.resources.add(resourcesItem);
        return this;
    }

    public List<@NotNull String> getVerbs() {
        return this.verbs;
    }

    public void setVerbs(List<@NotNull String> verbs) {
        this.verbs = verbs;
    }

    public V1ResourcePolicyRule verbs(List<@NotNull String> verbs) {
        this.verbs = verbs;
        return this;
    }

    public V1ResourcePolicyRule addVerbsItem(String verbsItem) {
        this.verbs.add(verbsItem);
        return this;
    }

    public Boolean getClusterScope() {
        return this.clusterScope;
    }

    public void setClusterScope(Boolean clusterScope) {
        this.clusterScope = clusterScope;
    }

    public V1ResourcePolicyRule clusterScope(Boolean clusterScope) {
        this.clusterScope = clusterScope;
        return this;
    }

    public List<@NotNull String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(List<@NotNull String> namespaces) {
        this.namespaces = namespaces;
    }

    public V1ResourcePolicyRule namespaces(List<@NotNull String> namespaces) {
        this.namespaces = namespaces;
        return this;
    }

    public V1ResourcePolicyRule addNamespacesItem(String namespacesItem) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(namespacesItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourcePolicyRule v1ResourcePolicyRule = (V1ResourcePolicyRule)o;
        return Objects.equals(this.apiGroups, v1ResourcePolicyRule.apiGroups) && Objects.equals(this.resources, v1ResourcePolicyRule.resources) && Objects.equals(this.verbs, v1ResourcePolicyRule.verbs) && Objects.equals(this.clusterScope, v1ResourcePolicyRule.clusterScope) && Objects.equals(this.namespaces, v1ResourcePolicyRule.namespaces);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroups, this.resources, this.verbs, this.clusterScope, this.namespaces);
    }

    public String toString() {
        return "V1ResourcePolicyRule(apiGroups: " + this.getApiGroups() + ", resources: " + this.getResources() + ", verbs: " + this.getVerbs() + ", clusterScope: " + this.getClusterScope() + ", namespaces: " + this.getNamespaces() + ")";
    }
}

