/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1ResourceClaim;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"claims", "limits", "requests"})
public class V1ResourceRequirements {
    public static final String JSON_PROPERTY_CLAIMS = "claims";
    public static final String JSON_PROPERTY_LIMITS = "limits";
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    @Nullable
    @JsonProperty(value="claims")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1ResourceClaim> claims;
    @Nullable
    @JsonProperty(value="limits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> limits;
    @Nullable
    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> requests;

    public List<@Valid V1ResourceClaim> getClaims() {
        return this.claims;
    }

    public void setClaims(List<@Valid V1ResourceClaim> claims) {
        this.claims = claims;
    }

    public V1ResourceRequirements claims(List<@Valid V1ResourceClaim> claims) {
        this.claims = claims;
        return this;
    }

    public V1ResourceRequirements addClaimsItem(V1ResourceClaim claimsItem) {
        if (this.claims == null) {
            this.claims = new ArrayList<V1ResourceClaim>();
        }
        this.claims.add(claimsItem);
        return this;
    }

    public Map<String, @NotNull String> getLimits() {
        return this.limits;
    }

    public void setLimits(Map<String, @NotNull String> limits) {
        this.limits = limits;
    }

    public V1ResourceRequirements limits(Map<String, @NotNull String> limits) {
        this.limits = limits;
        return this;
    }

    public V1ResourceRequirements putLimitsItem(String key, String limitsItem) {
        if (this.limits == null) {
            this.limits = new HashMap<String, String>();
        }
        this.limits.put(key, limitsItem);
        return this;
    }

    public Map<String, @NotNull String> getRequests() {
        return this.requests;
    }

    public void setRequests(Map<String, @NotNull String> requests) {
        this.requests = requests;
    }

    public V1ResourceRequirements requests(Map<String, @NotNull String> requests) {
        this.requests = requests;
        return this;
    }

    public V1ResourceRequirements putRequestsItem(String key, String requestsItem) {
        if (this.requests == null) {
            this.requests = new HashMap<String, String>();
        }
        this.requests.put(key, requestsItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceRequirements v1ResourceRequirements = (V1ResourceRequirements)o;
        return Objects.equals(this.claims, v1ResourceRequirements.claims) && Objects.equals(this.limits, v1ResourceRequirements.limits) && Objects.equals(this.requests, v1ResourceRequirements.requests);
    }

    public int hashCode() {
        return Objects.hash(this.claims, this.limits, this.requests);
    }

    public String toString() {
        return "V1ResourceRequirements(claims: " + this.getClaims() + ", limits: " + this.getLimits() + ", requests: " + this.getRequests() + ")";
    }
}

