/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1AppArmorProfile;
import io.micronaut.kubernetes.client.openapi.model.V1Capabilities;
import io.micronaut.kubernetes.client.openapi.model.V1SELinuxOptions;
import io.micronaut.kubernetes.client.openapi.model.V1SeccompProfile;
import io.micronaut.kubernetes.client.openapi.model.V1WindowsSecurityContextOptions;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"allowPrivilegeEscalation", "appArmorProfile", "capabilities", "privileged", "procMount", "readOnlyRootFilesystem", "runAsGroup", "runAsNonRoot", "runAsUser", "seLinuxOptions", "seccompProfile", "windowsOptions"})
public class V1SecurityContext {
    public static final String JSON_PROPERTY_ALLOW_PRIVILEGE_ESCALATION = "allowPrivilegeEscalation";
    public static final String JSON_PROPERTY_APP_ARMOR_PROFILE = "appArmorProfile";
    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    public static final String JSON_PROPERTY_PRIVILEGED = "privileged";
    public static final String JSON_PROPERTY_PROC_MOUNT = "procMount";
    public static final String JSON_PROPERTY_READ_ONLY_ROOT_FILESYSTEM = "readOnlyRootFilesystem";
    public static final String JSON_PROPERTY_RUN_AS_GROUP = "runAsGroup";
    public static final String JSON_PROPERTY_RUN_AS_NON_ROOT = "runAsNonRoot";
    public static final String JSON_PROPERTY_RUN_AS_USER = "runAsUser";
    public static final String JSON_PROPERTY_SE_LINUX_OPTIONS = "seLinuxOptions";
    public static final String JSON_PROPERTY_SECCOMP_PROFILE = "seccompProfile";
    public static final String JSON_PROPERTY_WINDOWS_OPTIONS = "windowsOptions";
    @Nullable
    @JsonProperty(value="allowPrivilegeEscalation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean allowPrivilegeEscalation;
    @Nullable
    @Valid
    @JsonProperty(value="appArmorProfile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1AppArmorProfile appArmorProfile;
    @Nullable
    @Valid
    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1Capabilities capabilities;
    @Nullable
    @JsonProperty(value="privileged")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean privileged;
    @Nullable
    @JsonProperty(value="procMount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String procMount;
    @Nullable
    @JsonProperty(value="readOnlyRootFilesystem")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean readOnlyRootFilesystem;
    @Nullable
    @JsonProperty(value="runAsGroup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Long runAsGroup;
    @Nullable
    @JsonProperty(value="runAsNonRoot")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean runAsNonRoot;
    @Nullable
    @JsonProperty(value="runAsUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Long runAsUser;
    @Nullable
    @Valid
    @JsonProperty(value="seLinuxOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1SELinuxOptions seLinuxOptions;
    @Nullable
    @Valid
    @JsonProperty(value="seccompProfile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1SeccompProfile seccompProfile;
    @Nullable
    @Valid
    @JsonProperty(value="windowsOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1WindowsSecurityContextOptions windowsOptions;

    public Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public void setAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
    }

    public V1SecurityContext allowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return this;
    }

    public V1AppArmorProfile getAppArmorProfile() {
        return this.appArmorProfile;
    }

    public void setAppArmorProfile(V1AppArmorProfile appArmorProfile) {
        this.appArmorProfile = appArmorProfile;
    }

    public V1SecurityContext appArmorProfile(V1AppArmorProfile appArmorProfile) {
        this.appArmorProfile = appArmorProfile;
        return this;
    }

    public V1Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(V1Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    public V1SecurityContext capabilities(V1Capabilities capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    public V1SecurityContext privileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    public String getProcMount() {
        return this.procMount;
    }

    public void setProcMount(String procMount) {
        this.procMount = procMount;
    }

    public V1SecurityContext procMount(String procMount) {
        this.procMount = procMount;
        return this;
    }

    public Boolean getReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    public void setReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
    }

    public V1SecurityContext readOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return this;
    }

    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public void setRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
    }

    public V1SecurityContext runAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return this;
    }

    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public void setRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
    }

    public V1SecurityContext runAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return this;
    }

    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
    }

    public V1SecurityContext runAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    public V1SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions;
    }

    public void setSeLinuxOptions(V1SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
    }

    public V1SecurityContext seLinuxOptions(V1SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
        return this;
    }

    public V1SeccompProfile getSeccompProfile() {
        return this.seccompProfile;
    }

    public void setSeccompProfile(V1SeccompProfile seccompProfile) {
        this.seccompProfile = seccompProfile;
    }

    public V1SecurityContext seccompProfile(V1SeccompProfile seccompProfile) {
        this.seccompProfile = seccompProfile;
        return this;
    }

    public V1WindowsSecurityContextOptions getWindowsOptions() {
        return this.windowsOptions;
    }

    public void setWindowsOptions(V1WindowsSecurityContextOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
    }

    public V1SecurityContext windowsOptions(V1WindowsSecurityContextOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1SecurityContext v1SecurityContext = (V1SecurityContext)o;
        return Objects.equals(this.allowPrivilegeEscalation, v1SecurityContext.allowPrivilegeEscalation) && Objects.equals(this.appArmorProfile, v1SecurityContext.appArmorProfile) && Objects.equals(this.capabilities, v1SecurityContext.capabilities) && Objects.equals(this.privileged, v1SecurityContext.privileged) && Objects.equals(this.procMount, v1SecurityContext.procMount) && Objects.equals(this.readOnlyRootFilesystem, v1SecurityContext.readOnlyRootFilesystem) && Objects.equals(this.runAsGroup, v1SecurityContext.runAsGroup) && Objects.equals(this.runAsNonRoot, v1SecurityContext.runAsNonRoot) && Objects.equals(this.runAsUser, v1SecurityContext.runAsUser) && Objects.equals(this.seLinuxOptions, v1SecurityContext.seLinuxOptions) && Objects.equals(this.seccompProfile, v1SecurityContext.seccompProfile) && Objects.equals(this.windowsOptions, v1SecurityContext.windowsOptions);
    }

    public int hashCode() {
        return Objects.hash(this.allowPrivilegeEscalation, this.appArmorProfile, this.capabilities, this.privileged, this.procMount, this.readOnlyRootFilesystem, this.runAsGroup, this.runAsNonRoot, this.runAsUser, this.seLinuxOptions, this.seccompProfile, this.windowsOptions);
    }

    public String toString() {
        return "V1SecurityContext(allowPrivilegeEscalation: " + this.getAllowPrivilegeEscalation() + ", appArmorProfile: " + this.getAppArmorProfile() + ", capabilities: " + this.getCapabilities() + ", privileged: " + this.getPrivileged() + ", procMount: " + this.getProcMount() + ", readOnlyRootFilesystem: " + this.getReadOnlyRootFilesystem() + ", runAsGroup: " + this.getRunAsGroup() + ", runAsNonRoot: " + this.getRunAsNonRoot() + ", runAsUser: " + this.getRunAsUser() + ", seLinuxOptions: " + this.getSeLinuxOptions() + ", seccompProfile: " + this.getSeccompProfile() + ", windowsOptions: " + this.getWindowsOptions() + ")";
    }
}

