/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1BoundObjectReference;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"audiences", "boundObjectRef", "expirationSeconds"})
public class V1TokenRequestSpec {
    public static final String JSON_PROPERTY_AUDIENCES = "audiences";
    public static final String JSON_PROPERTY_BOUND_OBJECT_REF = "boundObjectRef";
    public static final String JSON_PROPERTY_EXPIRATION_SECONDS = "expirationSeconds";
    @NotNull
    @JsonProperty(value="audiences")
    private @NotNull List<@NotNull String> audiences;
    @Nullable
    @Valid
    @JsonProperty(value="boundObjectRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1BoundObjectReference boundObjectRef;
    @Nullable
    @JsonProperty(value="expirationSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Long expirationSeconds;

    public V1TokenRequestSpec(List<@NotNull String> audiences) {
        this.audiences = audiences;
    }

    public List<@NotNull String> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(List<@NotNull String> audiences) {
        this.audiences = audiences;
    }

    public V1TokenRequestSpec audiences(List<@NotNull String> audiences) {
        this.audiences = audiences;
        return this;
    }

    public V1TokenRequestSpec addAudiencesItem(String audiencesItem) {
        this.audiences.add(audiencesItem);
        return this;
    }

    public V1BoundObjectReference getBoundObjectRef() {
        return this.boundObjectRef;
    }

    public void setBoundObjectRef(V1BoundObjectReference boundObjectRef) {
        this.boundObjectRef = boundObjectRef;
    }

    public V1TokenRequestSpec boundObjectRef(V1BoundObjectReference boundObjectRef) {
        this.boundObjectRef = boundObjectRef;
        return this;
    }

    public Long getExpirationSeconds() {
        return this.expirationSeconds;
    }

    public void setExpirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
    }

    public V1TokenRequestSpec expirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1TokenRequestSpec v1TokenRequestSpec = (V1TokenRequestSpec)o;
        return Objects.equals(this.audiences, v1TokenRequestSpec.audiences) && Objects.equals(this.boundObjectRef, v1TokenRequestSpec.boundObjectRef) && Objects.equals(this.expirationSeconds, v1TokenRequestSpec.expirationSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.boundObjectRef, this.expirationSeconds);
    }

    public String toString() {
        return "V1TokenRequestSpec(audiences: " + this.getAudiences() + ", boundObjectRef: " + this.getBoundObjectRef() + ", expirationSeconds: " + this.getExpirationSeconds() + ")";
    }
}

