/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1UserInfo;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"audiences", "authenticated", "error", "user"})
public class V1TokenReviewStatus {
    public static final String JSON_PROPERTY_AUDIENCES = "audiences";
    public static final String JSON_PROPERTY_AUTHENTICATED = "authenticated";
    public static final String JSON_PROPERTY_ERROR = "error";
    public static final String JSON_PROPERTY_USER = "user";
    @Nullable
    @JsonProperty(value="audiences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> audiences;
    @Nullable
    @JsonProperty(value="authenticated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean authenticated;
    @Nullable
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String error;
    @Nullable
    @Valid
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1UserInfo user;

    public List<@NotNull String> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(List<@NotNull String> audiences) {
        this.audiences = audiences;
    }

    public V1TokenReviewStatus audiences(List<@NotNull String> audiences) {
        this.audiences = audiences;
        return this;
    }

    public V1TokenReviewStatus addAudiencesItem(String audiencesItem) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(audiencesItem);
        return this;
    }

    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
    }

    public V1TokenReviewStatus authenticated(Boolean authenticated) {
        this.authenticated = authenticated;
        return this;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public V1TokenReviewStatus error(String error) {
        this.error = error;
        return this;
    }

    public V1UserInfo getUser() {
        return this.user;
    }

    public void setUser(V1UserInfo user) {
        this.user = user;
    }

    public V1TokenReviewStatus user(V1UserInfo user) {
        this.user = user;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1TokenReviewStatus v1TokenReviewStatus = (V1TokenReviewStatus)o;
        return Objects.equals(this.audiences, v1TokenReviewStatus.audiences) && Objects.equals(this.authenticated, v1TokenReviewStatus.authenticated) && Objects.equals(this.error, v1TokenReviewStatus.error) && Objects.equals(this.user, v1TokenReviewStatus.user);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.authenticated, this.error, this.user);
    }

    public String toString() {
        return "V1TokenReviewStatus(audiences: " + this.getAudiences() + ", authenticated: " + this.getAuthenticated() + ", error: " + this.getError() + ", user: " + this.getUser() + ")";
    }
}

